/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.HideableElement;
import net.avh4.math.geometry.Rect;
import net.avh4.util.Util;

public class ScenePlaceholder
extends HideableElement
implements Element {
    private final String name;
    protected final int color;
    protected final int textColor;

    public ScenePlaceholder(String name) {
        this(name, Util.getHashColor(name));
    }

    public ScenePlaceholder(String name, int color) {
        this.name = name;
        this.color = color;
        this.textColor = Util.getContrastingColor(color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScenePlaceholder that = (ScenePlaceholder)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void drawGivenVisible(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        int MARGIN = 5;
        double x = bounds.minX();
        double y = bounds.minY();
        double height = bounds.height();
        g.drawRect(x, y, bounds.width(), height, this.color);
        g.drawText(this.name, x + 5.0, y + height - 5.0, Font.PFENNIG, this.textColor);
    }
}

