/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Rect;

public class SceneLabel
implements Element {
    protected String text;
    protected final Font font;
    protected final int color;

    public SceneLabel(String text, Font font, int color) {
        this.text = text;
        this.color = color;
        this.font = font;
    }

    public SceneLabel(String text, String customFontResource, int fontSize, int color) {
        this(text, new Font(customFontResource).size(fontSize), color);
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        double labelWidth = fm.stringWidth(this.font, this.text);
        double x = bounds.minX() - labelWidth / 2.0;
        double y = bounds.minY() + (double)fm.getLineHeight(this.font);
        g.drawText(this.text, x, y, this.font, this.color);
    }
}

