/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Image;
import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.math.geometry.Rect;

public class SceneImage
implements Element {
    protected Image image;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;

    public SceneImage(Image image, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.image = image;
        this.clipX = clipX;
        this.clipY = clipY;
        this.clipWidth = clipWidth;
        this.clipHeight = clipHeight;
    }

    public SceneImage(Image image) {
        this(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public SceneImage(String imageName) {
        this(UILayer.loadImageResource(imageName));
    }

    public SceneImage(String imageName, int clipX, int clipY, int clipWidth, int clipHeight) {
        this(UILayer.loadImageResource(imageName), clipX, clipY, clipWidth, clipHeight);
    }

    public SceneImage() {
        this.image = null;
        this.clipX = 0;
        this.clipY = 0;
        this.clipWidth = 0;
        this.clipHeight = 0;
    }

    public void setClipPosition(int clipX, int clipY) {
        this.clipX = clipX;
        this.clipY = clipY;
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        double x = bounds.minX();
        double y = bounds.minY();
        double width = bounds.width();
        double height = bounds.height();
        if (this.image == null) {
            new ScenePlaceholder("Missing Image").draw(Rect.fromTopLeft((double)x, (double)y, (double)width, (double)height), g, fm);
        } else {
            g.drawImage(this.image, x, y, x + width, y + height, this.clipX, this.clipY, this.clipX + this.clipWidth, this.clipY + this.clipHeight);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.clipX = 0;
        this.clipY = 0;
        this.clipWidth = image.getWidth();
        this.clipHeight = image.getHeight();
    }
}

