/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Rect;

public class SceneCenteredText
implements Element {
    protected final Font font;
    protected final int color;
    protected String text;

    public SceneCenteredText(String text, Font font, int color) {
        this.text = text;
        this.font = font;
        this.color = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        float ascent = fm.getAscent(this.font);
        double x = bounds.minX() + (bounds.width() - (double)fm.stringWidth(this.font, this.text)) / 2.0;
        double y = bounds.minY() + (double)ascent + (bounds.height() - (double)ascent - (double)fm.getDescent(this.font)) / 2.0;
        g.drawText(this.text, x, y, this.font, this.color);
    }
}

