/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import java.util.ArrayList;
import java.util.Iterator;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.Item;
import net.avh4.math.geometry.Rect;

public class Scene
implements Iterable<Item>,
Element {
    private final ArrayList<Item> children = new ArrayList();
    protected String title;
    private double width = 800.0;
    private double height = 600.0;

    public Scene(String title) {
        this.title = title;
    }

    public Scene() {
        this("untitled scene");
    }

    public Scene(Item e) {
        this(e.toString());
        this.setTitle(this.title);
        this.setSize(this.width, this.height);
        this.add(e);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public Item add(Item item) {
        this.children.add(item);
        return item;
    }

    public Item add(Rect bounds, Element element) {
        return this.add(new Item(bounds, element));
    }

    @Override
    public Iterator<Item> iterator() {
        return this.children.iterator();
    }

    public Item findSceneElement(Object what) {
        for (Item child : this.children) {
            if (!child.element.equals(what)) continue;
            return child;
        }
        return null;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Scene{").append("title='").append(this.title).append('\'').append(", width=").append(this.width).append(", height=").append(this.height).append(", children=").append(this.children);
        for (Item child : this.children) {
            sb.append("\n    ").append(child).append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        g.drawRect(bounds, -16777216);
        for (Item item : this.children) {
            item.element.draw(item.bounds.scale(Rect.ofSize((double)800.0, (double)600.0), bounds), g, fm);
        }
    }
}

