/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.Image;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.math.geometry.Rect;

public abstract class GraphicsOperations {
    public void drawRect(Rect bounds, int argbColor) {
        this.drawRect(bounds.minX(), bounds.minY(), bounds.width(), bounds.height(), argbColor);
    }

    public abstract void drawRect(double var1, double var3, double var5, double var7, int var9);

    public abstract void drawText(String var1, double var2, double var4, Font var6, int var7);

    public void drawText(FontMetricsService fm, String text, Rect bounds, Font font, int color) {
        double ascender = fm.getAscender(font);
        this.drawText(text, bounds.minX(), bounds.midY() + ascender / 2.0, font, color);
    }

    public abstract void translate(double var1, double var3);

    public abstract void drawLine(double var1, double var3, double var5, double var7, int var9);

    public void drawOval(Rect bounds, int argbColor) {
        this.drawOval(bounds.minX(), bounds.minY(), bounds.width(), bounds.height(), argbColor);
    }

    public abstract void drawOval(double var1, double var3, double var5, double var7, int var9);

    public abstract void drawImage(Image var1, double var2, double var4, double var6, double var8, int var10, int var11, int var12, int var13);

    public void drawImage(Image image, Rect bounds, Rect sourceClip) {
        this.drawImage(image, bounds.minX(), bounds.minY(), bounds.maxX(), bounds.maxY(), (int)sourceClip.minX(), (int)sourceClip.minY(), (int)sourceClip.maxX(), (int)sourceClip.maxY());
    }

    public void drawImage(Image image, Rect bounds) {
        this.drawImage(image, bounds.minX(), bounds.minY(), bounds.maxX(), bounds.maxY(), 0, 0, image.getWidth(), image.getHeight());
    }

    private void drawImage(Image image, Rect bounds, int sourceLeftX, int sourceTopY, int sourceRightX, int sourceBottomY) {
        this.drawImage(image, bounds.minX(), bounds.minY(), bounds.maxX(), bounds.maxY(), sourceLeftX, sourceTopY, sourceRightX, sourceBottomY);
    }
}

