/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.scene.ClippedElementDelegate;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Rect;

public class ClippedElement
implements Element {
    protected ClippedElementDelegate delegate;
    private int clipX;
    private int clipY;

    public ClippedElement(ClippedElementDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void draw(Rect bounds, GraphicsOperations g, FontMetricsService fm) {
        double x = bounds.minX();
        double y = bounds.minY();
        g.translate(x, y);
        this.delegate.draw(g, fm, this.clipX, this.clipY, bounds.width(), bounds.height());
        g.translate(-x, -y);
    }

    public void setClipPosition(int leftX, int topY) {
        this.clipX = leftX;
        this.clipY = topY;
    }

    public void setDelegate(ClippedElementDelegate delegate) {
        this.delegate = delegate;
    }
}

