/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.layout;

import net.avh4.framework.uilayer.layout.BoundsTransformation;
import net.avh4.framework.uilayer.layout.Layout;
import net.avh4.math.geometry.Rect;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class VerticalLayout<T>
implements Layout<T> {
    private final HashPMap<T, SizingStrategy> strategies;

    public VerticalLayout() {
        this.strategies = HashTreePMap.empty();
    }

    private VerticalLayout(HashPMap<T, SizingStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public BoundsTransformation get(final T key) {
        return new BoundsTransformation(){

            @Override
            public Rect apply(Rect bounds) {
                SizingStrategy strategy = (SizingStrategy)VerticalLayout.this.strategies.get(key);
                double height = strategy.calculateHeight(bounds);
                double minY = strategy.calculateMinY(bounds);
                return Rect.fromTopLeft((double)0.0, (double)minY, (double)bounds.width(), (double)height);
            }
        };
    }

    public VerticalLayout<T> addAspectRatio(T key, double aspectRatio) {
        HashPMap newStrategies = this.strategies.plus(key, (Object)new AspectRatioSizingStrategy((PMap)this.strategies, aspectRatio));
        return new VerticalLayout<T>(newStrategies);
    }

    public VerticalLayout<T> addFixedHeight(T key, double height) {
        HashPMap newStrategies = this.strategies.plus(key, (Object)new FixedHeightSizingStrategy((PMap)this.strategies, height));
        return new VerticalLayout<T>(newStrategies);
    }

    private static class FixedHeightSizingStrategy
    extends SizingStrategyBase {
        private final double height;

        private FixedHeightSizingStrategy(PMap<?, SizingStrategy> predecessors, double height) {
            super(predecessors);
            this.height = height;
        }

        @Override
        public double calculateHeight(Rect bounds) {
            return this.height;
        }
    }

    private static class AspectRatioSizingStrategy
    extends SizingStrategyBase {
        private final double aspectRatio;

        private AspectRatioSizingStrategy(PMap<?, SizingStrategy> predecessors, double aspectRatio) {
            super(predecessors);
            this.aspectRatio = aspectRatio;
        }

        @Override
        public double calculateHeight(Rect bounds) {
            return bounds.width() / this.aspectRatio;
        }
    }

    public static abstract class SizingStrategyBase
    implements SizingStrategy {
        protected final PMap<?, SizingStrategy> predecessors;

        public SizingStrategyBase(PMap<?, SizingStrategy> predecessors) {
            this.predecessors = predecessors;
        }

        @Override
        public double calculateMinY(Rect bounds) {
            double sum = 0.0;
            for (SizingStrategy s : this.predecessors.values()) {
                sum += s.calculateHeight(bounds);
            }
            return sum;
        }

        @Override
        public abstract double calculateHeight(Rect var1);
    }

    private static interface SizingStrategy {
        public double calculateMinY(Rect var1);

        public double calculateHeight(Rect var1);
    }
}

