/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.animation;

import net.avh4.framework.uilayer.TimeService;

public class AnimatedBoolean {
    public final int animationDurationMs;
    private final TimeService timeService = new TimeService();
    private double startValue;
    private double endValue;
    private long startTime;
    private long endTime;

    public AnimatedBoolean(int animationDurationMs) {
        this.animationDurationMs = animationDurationMs;
    }

    public void set(boolean value) {
        long now = this.timeService.nowMs();
        this.startValue = this.endValue;
        this.endValue = value ? 1.0 : 0.0;
        this.startTime = now;
        this.endTime = now + (long)this.animationDurationMs;
    }

    public double get() {
        long now = this.timeService.nowMs();
        if (now >= this.endTime) {
            return this.endValue;
        }
        if (now <= this.startTime) {
            return this.startValue;
        }
        return this.endValue - (this.endValue - this.startValue) * (double)(this.endTime - now) / (double)(this.endTime - this.startTime);
    }
}

