/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer;

import java.io.IOException;
import net.avh4.framework.data.ExternalStorage;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.Image;
import net.avh4.framework.uilayer.NullUILayerService;
import net.avh4.framework.uilayer.TimerUpdate;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayerService;
import net.avh4.framework.uilayer.input.ClickReceiver;
import net.avh4.framework.uilayer.input.KeyReceiver;
import net.avh4.framework.uilayer.mvc.Controller;
import net.avh4.framework.uilayer.mvc.MvcUi;
import net.avh4.framework.uilayer.mvc.View;

public class UILayer {
    private static final String SWING_SERVICE = "net.avh4.framework.uilayer.swing.SwingUILayerService";
    private static final String ANDROID_SERVICE = "net.avh4.framework.uilayer.android.AndroidUILayerService";
    private static final String IOS_SERVICE = "net.avh4.framework.uilayer.ios.IOSUILayerService";
    static final String[] KNOWN_SERVICES = new String[]{"net.avh4.framework.uilayer.swing.SwingUILayerService", "net.avh4.framework.uilayer.android.AndroidUILayerService"};
    public static final UILayerService service = UILayer.loadService();

    public static void main(UI game) {
        UILayer.main(game, game, game, game);
    }

    private static UILayerService loadService() {
        for (String serviceName : KNOWN_SERVICES) {
            UILayerService service = UILayer.loadService(serviceName);
            if (service == null) continue;
            return service;
        }
        return new NullUILayerService();
    }

    private static UILayerService loadService(String serviceName) {
        try {
            Class<?> clazz = UILayer.class.getClassLoader().loadClass(serviceName);
            return (UILayerService)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format("Could not instantiate %s", serviceName), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Could not instantiate %s", serviceName), e);
        }
    }

    public static void main(Element game, ClickReceiver receiver, KeyReceiver keyReceiver, TimerUpdate timerUpdate) {
        service.run(game, receiver, keyReceiver, timerUpdate);
    }

    public static Image loadImageResource(String resourceName) {
        return service.loadImageResource(resourceName);
    }

    public static Image loadImageFile(String filename) throws IOException {
        return service.loadImageFile(filename);
    }

    public static ExternalStorage getExternalStorage() {
        return service.getExternalStorage();
    }

    public static <M, VC extends View<M> & Controller<M>> void main(M model, VC viewController) {
        UILayer.main(model, viewController, viewController);
    }

    public static <M> void main(M model, View<M> view, Controller<M> controller) {
        UILayer.main(new MvcUi<M>(model, view, controller));
    }
}

