/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer;

import java.util.ArrayList;
import java.util.HashMap;
import net.avh4.framework.uilayer.Element;
import net.avh4.framework.uilayer.TimeService;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.math.geometry.Rect;

public class ElementBoundsAnimator {
    public static final long ANIMATION_DURATION_MS = 500L;
    private final TimeService timeService;
    private final ArrayList<Element> visibleThings = new ArrayList();
    private final HashMap<Object, Rect> startBounds = new HashMap();
    private final HashMap<Object, Rect> endBounds = new HashMap();
    private final HashMap<Object, Long> startTime = new HashMap();
    private final HashMap<Object, Long> endTime = new HashMap();

    public ElementBoundsAnimator(TimeService timeService) {
        this.timeService = timeService;
    }

    public void updateElement(Rect bounds, Element element) {
        long now = this.timeService.nowMs();
        if (this.visibleThings.contains(element)) {
            if (bounds.equals((Object)this.endBounds.get(element))) {
                return;
            }
            this.startBounds.put(element, this.getBounds(now, element));
            this.endBounds.put(element, bounds);
            this.startTime.put(element, now);
            this.endTime.put(element, now + 500L);
            return;
        }
        this.visibleThings.remove(element);
        this.visibleThings.add(element);
        this.endBounds.put(element, bounds);
        this.endTime.put(element, now);
    }

    public void render(GraphicsOperations g, FontMetricsService fm) {
        long now = this.timeService.nowMs();
        for (Element element : this.visibleThings) {
            Rect bounds = this.getBounds(now, element);
            element.draw(bounds, g, fm);
        }
    }

    private Rect getBounds(long now, Object id) {
        Rect startBounds = this.startBounds.get(id);
        Rect endBounds = this.endBounds.get(id);
        long endTime = this.endTime.get(id);
        if (now >= endTime) {
            return endBounds;
        }
        long startTime = this.startTime.get(id);
        if (now <= startTime) {
            return startBounds;
        }
        double percent = (double)(now - startTime) / (double)(endTime - startTime);
        return Rect.interpolate((Rect)startBounds, (Rect)endBounds, (double)percent);
    }
}

