/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer;

public abstract class Color {
    public static final int BLACK = -16777216;
    public static final int BLUE = -16776961;
    public static final int GREEN = -16711936;
    public static final int GRAY = -8421505;
    public static final int GREY = -8421505;
    public static final int RED = -65536;
    public static final int WHITE = -1;
    public static final int YELLOW = -256;
    public static final int DARK_GRAY = -12566464;

    public static int getAlpha(int color) {
        return 0xFF & color >> 24;
    }

    public static int getRed(int color) {
        return 0xFF & color >> 16;
    }

    public static int getGreen(int color) {
        return 0xFF & color >> 8;
    }

    public static int getBlue(int color) {
        return 0xFF & color;
    }

    public static int getValue(int color) {
        return Math.max(Color.getRed(color), Math.max(Color.getGreen(color), Color.getBlue(color)));
    }

    public static int darken(double factor, int color) {
        return 0xFF000000 & color | (int)((double)(0xFF0000 & color) * (1.0 - factor)) & 0xFF0000 | (int)((double)(0xFF00 & color) * (1.0 - factor)) & 0xFF00 | (int)((double)(0xFF & color) * (1.0 - factor)) & 0xFF;
    }

    public static int fromRGB(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int alpha(int color, int a) {
        return 0xFFFFFF & color | (a & 0xFF) << 24;
    }

    private static double hue2rgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.1666666716337204) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666865348816) {
            return p + (q - p) * (0.6666666865348816 - t) * 6.0;
        }
        return p;
    }

    public static int fromHSL(double hueDegrees, double s, double l) {
        double r;
        double g;
        double b;
        double h = hueDegrees / 360.0;
        if (s == 0.0) {
            g = b = l;
            r = b;
        } else {
            double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
            double p = 2.0 * l - q;
            r = Color.hue2rgb(p, q, h + 0.3333333432674408);
            g = Color.hue2rgb(p, q, h);
            b = Color.hue2rgb(p, q, h - 0.3333333432674408);
        }
        return Color.fromRGB((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0));
    }

    public static int fromWA(double white, double alpha) {
        int whiteInt = (int)Math.round(white * 255.0);
        int alphaInt = (int)Math.round(alpha * 255.0);
        return Color.fromRGBA(whiteInt, whiteInt, whiteInt, alphaInt);
    }

    public static int fromRGBA(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static abstract class Solarized {
        public static final int base03 = -16766154;
        public static final int base02 = -16304574;
        public static final int base01 = -10981771;
        public static final int base00 = -10126461;
        public static final int base0 = -8153962;
        public static final int base1 = -7102047;
        public static final int base2 = -1120043;
        public static final int base3 = -133405;
        public static final int yellow = -4880128;
        public static final int orange = -3454186;
        public static final int red = -2346449;
        public static final int magenta = -2935166;
        public static final int violet = -9670204;
        public static final int blue = -14251054;
        public static final int cyan = -13983336;
        public static final int green = -8021760;
    }
}

