/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.data.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.avh4.framework.data.ExternalStorageException;
import net.avh4.framework.data.File;

public class ClasspathResourcesFile
implements File {
    private final String filename;
    private final String root;
    private String writtenContents = null;

    public ClasspathResourcesFile(String filename) {
        this(".", filename);
    }

    public ClasspathResourcesFile(String root, String filename) {
        this.root = root;
        this.filename = filename;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public String getContents() {
        if (this.writtenContents != null) {
            return this.writtenContents;
        }
        return this.getStringFromClasspath();
    }

    @Override
    public void writeContents(String data) throws ExternalStorageException {
        this.writtenContents = data;
    }

    public String getStringFromClasspath() {
        String resourcePath = this.root + "/" + this.filename;
        InputStream is = ClassLoader.getSystemResourceAsStream(resourcePath);
        if (is == null) {
            throw new RuntimeException("Resource " + resourcePath + " does not exist");
        }
        try {
            return ClasspathResourcesFile.readString(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readString(InputStream is) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    public boolean exists() {
        String resourcePath = this.root + "/" + this.filename;
        InputStream is = ClassLoader.getSystemResourceAsStream(resourcePath);
        return is != null;
    }
}

