/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.data.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.avh4.framework.data.ExternalStorage;
import net.avh4.framework.data.File;
import net.avh4.framework.data.test.ClasspathResourcesFile;

public class ClasspathResourcesExternalStorage
implements ExternalStorage {
    private final String root;
    private final ArrayList<String> allowedFiles = new ArrayList();
    private final HashMap<String, File> files = new HashMap();

    public ClasspathResourcesExternalStorage(String root) {
        this.root = root;
    }

    @Override
    public List<String> getFiles() {
        return this.allowedFiles;
    }

    public void allowFile(String filename) {
        this.allowedFiles.add(filename);
    }

    @Override
    public File getFile(String filename) {
        if (!this.files.containsKey(filename)) {
            ClasspathResourcesFile file = new ClasspathResourcesFile(this.root, filename);
            if (file.exists() && !this.allowedFiles.contains(filename)) {
                return null;
            }
            this.files.put(filename, file);
        }
        return this.files.get(filename);
    }
}

