/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.async;

import java.util.concurrent.Semaphore;
import net.avh4.framework.async.Function;
import net.avh4.framework.async.Promise;

public class Deferred<T>
implements Promise<T> {
    private T value;
    private boolean isResolved;
    private final Semaphore semaphore = new Semaphore(0);
    private Function<T, ?> pendingCallback;

    public synchronized void resolve(T value) {
        this.value = value;
        this.isResolved = true;
        this.semaphore.release();
        if (this.pendingCallback != null) {
            this.pendingCallback.apply(this.value);
        }
    }

    @Override
    public T waitForValue() throws InterruptedException {
        if (!this.isResolved) {
            this.semaphore.acquire();
        }
        return this.value;
    }

    @Override
    public synchronized void whenDone(Function<T, ?> callable) {
        if (this.isResolved) {
            callable.apply(this.value);
        } else {
            this.pendingCallback = callable;
        }
    }
}

