/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.SceneElementBase;

public class SceneText
extends SceneElementBase {
    protected String text;
    protected final Font font;
    protected final int color;

    public SceneText(String text, int x, int y, int width, Font customFont, int color) {
        this(text, text, x, y, width, customFont, color);
    }

    public SceneText(String text, int x, int y, int width, String customFontResource, int fontSize, int color) {
        this(text, x, y, width, new Font(customFontResource).size(fontSize), color);
    }

    public SceneText(String name, String text, int x, int y, int width, Font customFont, int color) {
        super(name, x, y, width, customFont.getLineHeight());
        this.text = text;
        this.color = color;
        this.font = customFont;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(GraphicsOperations g, FontMetricsService fm) {
        String[] words;
        int MAX_HEIGHT = 2000;
        float lineHeight = fm.getLineHeight(this.font);
        int curX = this.x;
        float curY = (float)this.y + fm.getAscent(this.font);
        for (String word : words = this.text.replaceAll("\n", " ").split(" ")) {
            float wordWidth = fm.stringWidth(this.font, word);
            if ((float)curX + wordWidth > (float)(this.x + this.width)) {
                curY += lineHeight;
                curX = this.x;
                if (curY >= (float)MAX_HEIGHT + lineHeight) {
                    return;
                }
            }
            g.drawText(word, curX, curY, this.font, this.color);
            curX = (int)((float)curX + fm.stringWidth(this.font, word + " "));
        }
    }
}

