/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.SceneCreator;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.GraphicsOperationsRenderer;
import net.avh4.framework.uilayer.scene.Scene;
import net.avh4.framework.uilayer.scene.SceneElement;
import net.avh4.framework.uilayer.scene.SceneElementBase;

public class SceneRenderer
implements GraphicsOperationsRenderer {
    private final SceneCreator creator;

    public SceneRenderer(SceneCreator creator) {
        this.creator = creator;
    }

    public SceneRenderer(final Scene scene) {
        this(new SceneCreator(){

            @Override
            public Scene getScene() {
                return scene;
            }
        });
    }

    public SceneRenderer(SceneElement e) {
        this(new Scene(e));
    }

    @Override
    public int getWidth() {
        Scene scene = this.creator.getScene();
        if (scene == null) {
            return 100;
        }
        return scene.getWidth();
    }

    @Override
    public int getHeight() {
        Scene scene = this.creator.getScene();
        if (scene == null) {
            return 100;
        }
        return scene.getHeight();
    }

    @Override
    public void render(GraphicsOperations g, FontMetricsService fm) {
        Scene s = this.creator.getScene();
        if (s == null) {
            g.drawRect(0, 0, this.getWidth(), this.getHeight(), -8421505);
            g.drawText("(No scene)", 0.0f, 20.0f, Font.PFENNIG, -16777216);
            return;
        }
        int height = s.getHeight();
        int width = s.getWidth();
        g.drawRect(0, 0, width, height, -16777216);
        for (SceneElement object : s) {
            SceneRenderer.draw(object, g, fm);
        }
    }

    static void draw(SceneElement e, GraphicsOperations g, FontMetricsService fm) {
        if (e instanceof SceneElementBase && ((SceneElementBase)e).isHidden()) {
            return;
        }
        e.draw(g, fm);
    }
}

