/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.SceneElementBase;

public class SceneLabel
extends SceneElementBase {
    protected String text;
    protected final Font font;
    protected final int color;

    public SceneLabel(String text, int x, int y, Font font, int color) {
        super(text, x, y, 1, 1);
        this.text = text;
        this.color = color;
        this.font = font;
    }

    public SceneLabel(String text, int x, int y, String customFontResource, int fontSize, int color) {
        this(text, x, y, new Font(customFontResource).size(fontSize), color);
    }

    @Override
    public void draw(GraphicsOperations g, FontMetricsService fm) {
        float labelWidth = fm.stringWidth(this.font, this.text);
        float x = (float)this.x - labelWidth / 2.0f;
        float y = (float)this.y + fm.getLineHeight(this.font);
        g.drawText(this.text, x, y, this.font, this.color);
    }
}

