/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.UILayer;
import net.avh4.framework.uilayer.UILayerService;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.SceneElementBase;

public class SceneImage
extends SceneElementBase {
    static UILayerService service = UILayer.service;
    protected final String image;
    protected int clipX;
    protected int clipY;
    protected final int clipWidth;
    protected final int clipHeight;

    public SceneImage(int x, int y, int width, int height, String imageName) {
        super(imageName, x, y, width, height);
        this.image = imageName;
        this.clipX = 0;
        this.clipY = 0;
        this.clipWidth = service.getImageWidth(this.image);
        this.clipHeight = service.getImageHeight(this.image);
    }

    public SceneImage(int x, int y, int width, int height, String imageName, int clipX, int clipY, int clipWidth, int clipHeight) {
        super(imageName, x, y, width, height);
        this.image = imageName;
        this.clipX = clipX;
        this.clipY = clipY;
        this.clipWidth = clipWidth;
        this.clipHeight = clipHeight;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setClipPosition(int clipX, int clipY) {
        this.clipX = clipX;
        this.clipY = clipY;
    }

    @Override
    public void draw(GraphicsOperations g, FontMetricsService fm) {
        g.drawImage(this.image, this.x, this.y, this.x + this.width, this.y + this.height, this.clipX, this.clipY, this.clipX + this.clipWidth, this.clipY + this.clipHeight);
    }
}

