/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.SceneElementBase;

public class SceneCenteredText
extends SceneElementBase {
    protected final Font font;
    protected final int color;
    protected String text;

    public SceneCenteredText(String text, int x, int y, int width, int height, Font font, int color) {
        super(text, x, y, width, height);
        this.text = text;
        this.font = font;
        this.color = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(GraphicsOperations g, FontMetricsService fm) {
        float ascent = fm.getAscent(this.font);
        float x = (float)this.x + ((float)this.width - fm.stringWidth(this.font, this.text)) / 2.0f;
        float y = (float)this.y + ascent + ((float)this.height - ascent - fm.getDescent(this.font)) / 2.0f;
        g.drawText(this.text, x, y, this.font, this.color);
    }
}

