/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import java.util.ArrayList;
import java.util.Iterator;
import net.avh4.framework.uilayer.scene.SceneElement;

public class Scene
implements Iterable<SceneElement> {
    private final ArrayList<SceneElement> children = new ArrayList();
    protected String title;
    private int width = 800;
    private int height = 600;

    public Scene(String title) {
        this.title = title;
    }

    public Scene() {
        this("untitled scene");
    }

    public Scene(SceneElement e) {
        this(e.toString());
        String title = e.getName();
        this.setTitle(title);
        int height = e.getHeight() + e.getY();
        int width = e.getWidth() + e.getX();
        this.setSize(width, height);
        this.add(e);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public <T extends SceneElement> T add(T element) {
        this.children.add(element);
        return element;
    }

    @Override
    public Iterator<SceneElement> iterator() {
        return this.children.iterator();
    }

    public <T extends SceneElement> T findSceneElement(String what) {
        for (SceneElement child : this.children) {
            if (!child.getName().equals(what)) continue;
            return (T)child;
        }
        return null;
    }

    public <T extends SceneElement> T findSceneElement(Class<T> elementType, String what) {
        return this.findSceneElement(what);
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }
}

