/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer;

import net.avh4.framework.uilayer.ClickReceiver;
import net.avh4.framework.uilayer.KeyReceiver;
import net.avh4.framework.uilayer.NullUILayerService;
import net.avh4.framework.uilayer.SceneCreator;
import net.avh4.framework.uilayer.UI;
import net.avh4.framework.uilayer.UILayerService;

public class UILayer {
    private static final String SWING_SERVICE = "net.avh4.framework.uilayer.swing.SwingUILayerService";
    private static final String ANDROID_SERVICE = "net.avh4.framework.uilayer.android.AndroidUILayerService";
    private static final String IOS_SERVICE = "net.avh4.framework.uilayer.ios.IOSUILayerService";
    static final String[] KNOWN_SERVICES = new String[]{"net.avh4.framework.uilayer.swing.SwingUILayerService", "net.avh4.framework.uilayer.android.AndroidUILayerService"};
    public static final UILayerService service = UILayer.loadService();

    public static void main(UI game) {
        UILayer.main(game, game, game);
    }

    private static UILayerService loadService() {
        for (String serviceName : KNOWN_SERVICES) {
            UILayerService service = UILayer.loadService(serviceName);
            if (service == null) continue;
            return service;
        }
        return new NullUILayerService();
    }

    private static UILayerService loadService(String serviceName) {
        try {
            Class<?> clazz = UILayer.class.getClassLoader().loadClass(serviceName);
            return (UILayerService)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format("Could not instantiate %s", serviceName), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Could not instantiate %s", serviceName), e);
        }
    }

    public static void main(SceneCreator game, ClickReceiver receiver, KeyReceiver keyReceiver) {
        service.run(game, receiver, keyReceiver);
    }
}

