/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.data.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.avh4.framework.data.ExternalStorage;

public class ClasspathResourcesExternalStorage
implements ExternalStorage {
    private final String root;
    private final ArrayList<String> allowedFiles = new ArrayList();

    public ClasspathResourcesExternalStorage(String root) {
        this.root = root;
    }

    @Override
    public String getString(String filename) {
        if (!this.allowedFiles.contains(filename)) {
            return null;
        }
        String resourcePath = this.root + "/" + filename;
        InputStream is = ClassLoader.getSystemResourceAsStream(resourcePath);
        if (is == null) {
            throw new RuntimeException("Resource " + resourcePath + " does not exist");
        }
        try {
            String content = this.readString(is);
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getFiles() {
        return this.allowedFiles;
    }

    private String readString(InputStream is) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    public void allowFile(String filename) {
        this.allowedFiles.add(filename);
    }
}

