/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.framework.uilayer.scene;

import net.avh4.framework.uilayer.Font;
import net.avh4.framework.uilayer.SceneCreator;
import net.avh4.framework.uilayer.scene.CompositeSceneElement;
import net.avh4.framework.uilayer.scene.FontMetricsService;
import net.avh4.framework.uilayer.scene.GraphicsOperations;
import net.avh4.framework.uilayer.scene.Scene;
import net.avh4.framework.uilayer.scene.SceneCenteredText;
import net.avh4.framework.uilayer.scene.SceneElement;
import net.avh4.framework.uilayer.scene.SceneImage;
import net.avh4.framework.uilayer.scene.SceneLabel;
import net.avh4.framework.uilayer.scene.SceneLine;
import net.avh4.framework.uilayer.scene.SceneOval;
import net.avh4.framework.uilayer.scene.ScenePlaceholder;
import net.avh4.framework.uilayer.scene.SceneRect;
import net.avh4.framework.uilayer.scene.SceneText;

public class SceneRenderer {
    private final SceneCreator creator;
    private final GraphicsOperations g;
    private final FontMetricsService fm;

    public SceneRenderer(SceneCreator creator, GraphicsOperations g, FontMetricsService fm) {
        this.creator = creator;
        this.g = g;
        this.fm = fm;
    }

    public int getWidth() {
        Scene scene = this.creator.getScene();
        if (scene == null) {
            return 100;
        }
        return scene.getWidth();
    }

    public int getHeight() {
        Scene scene = this.creator.getScene();
        if (scene == null) {
            return 100;
        }
        return scene.getHeight();
    }

    public void render() {
        Scene s = this.creator.getScene();
        if (s == null) {
            this.g.drawRect(0, 0, this.getWidth(), this.getHeight(), -8421505);
            this.g.drawText("(No scene)", 0.0f, 20.0f, Font.PFENNIG, -16777216);
            return;
        }
        int height = s.getHeight();
        int width = s.getWidth();
        this.g.drawRect(0, 0, width, height, -16777216);
        for (SceneElement object : s) {
            this.draw(object);
        }
    }

    private void draw(SceneElement e) {
        if (e.isHidden()) {
            return;
        }
        if (e instanceof CompositeSceneElement) {
            this.drawComposite((CompositeSceneElement)e);
        } else if (e instanceof SceneCenteredText) {
            this.drawCenteredText((SceneCenteredText)e);
        } else if (e instanceof SceneText) {
            this.drawText((SceneText)e);
        } else if (e instanceof ScenePlaceholder) {
            this.drawPlaceholder((ScenePlaceholder)e);
        } else if (e instanceof SceneImage) {
            this.drawImage((SceneImage)e);
        } else if (e instanceof SceneRect) {
            this.drawRect((SceneRect)e);
        } else if (e instanceof SceneOval) {
            this.drawOval((SceneOval)e);
        } else if (e instanceof SceneLabel) {
            this.drawLabel((SceneLabel)e);
        } else if (e instanceof SceneLine) {
            this.drawLine((SceneLine)e);
        } else {
            throw new RuntimeException("Don't know how to render " + e.getClass().getSimpleName());
        }
    }

    private void drawComposite(CompositeSceneElement e) {
        this.g.translate(e.x, e.y);
        for (SceneElement object : e.getSceneElements()) {
            this.draw(object);
        }
        this.g.translate(-e.x, -e.y);
    }

    private void drawCenteredText(SceneCenteredText e) {
        float ascent = this.fm.getAscent(e.font);
        float x = (float)e.x + ((float)e.width - this.fm.stringWidth(e.font, e.text)) / 2.0f;
        float y = (float)e.y + ascent + ((float)e.height - ascent - this.fm.getDescent(e.font)) / 2.0f;
        this.g.drawText(e.text, x, y, e.font, e.color);
    }

    private void drawLine(SceneLine e) {
        this.g.drawLine(e.x1, e.y1, e.x2, e.y2, e.color);
    }

    private void drawRect(SceneRect e) {
        this.g.drawRect(e.x, e.y, e.width, e.height, e.color);
    }

    private void drawOval(SceneOval e) {
        this.g.drawOval(e.x, e.y, e.width, e.height, e.color);
    }

    private void drawImage(SceneImage e) {
        this.g.drawImage(e.image, e.x, e.y, e.x + e.width, e.y + e.height, e.clipX, e.clipY, e.clipX + e.clipWidth, e.clipY + e.clipHeight);
    }

    private void drawPlaceholder(ScenePlaceholder e) {
        int MARGIN = 5;
        this.g.drawRect(e.x, e.y, e.width, e.height, e.color);
        this.g.drawText(e.name, e.x + 5, e.y + e.height - 5, Font.PFENNIG, e.textColor);
    }

    private void drawText(SceneText e) {
        String[] words;
        float lineHeight = this.fm.getLineHeight(e.font);
        int curX = e.x;
        float curY = (float)e.y + this.fm.getAscent(e.font);
        for (String word : words = e.text.replaceAll("\n", " ").split(" ")) {
            float wordWidth = this.fm.stringWidth(e.font, word);
            if ((float)curX + wordWidth >= (float)(e.x + e.width)) {
                curY += lineHeight;
                curX = e.x;
                if (curY >= (float)this.getHeight() + lineHeight) {
                    return;
                }
            }
            this.g.drawText(word, curX, curY, e.font, e.color);
            curX = (int)((float)curX + this.fm.stringWidth(e.font, word + " "));
        }
    }

    private void drawLabel(SceneLabel e) {
        float labelWidth = this.fm.stringWidth(e.font, e.text);
        float x = (float)e.x - labelWidth / 2.0f;
        float y = (float)e.y + this.fm.getLineHeight(e.font);
        this.g.drawText(e.text, x, y, e.font, e.color);
    }
}

