/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.utils;

import com.google.common.base.Preconditions;

public enum Level {
    TRACE(0, "TRACE"),
    DEBUG(1, "DEBUG"),
    INFO(2, "INFO "),
    WARN(3, "WARN "),
    ERROR(4, "ERROR"),
    FATAL(5, "FATAL");

    private final int value;
    private final String paddedLabel;

    private Level(int value, String paddedLabel) {
        this.value = value;
        this.paddedLabel = (String)Preconditions.checkNotNull((Object)paddedLabel, (Object)"paddedLabel");
    }

    public int intValue() {
        return this.value;
    }

    public String paddedLabel() {
        return this.paddedLabel;
    }

    public boolean isGreaterThan(Level level) {
        Preconditions.checkNotNull((Object)((Object)level), (Object)"level");
        return this.value > level.value;
    }
}

