/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.utils;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.avcompris.commons3.utils.Level;
import net.avcompris.commons3.utils.LogUtils;
import org.apache.commons.logging.Log;

public abstract class LogFactory {
    private static final ThreadLocal<String> CORRELATION_IDS = new ThreadLocal();
    private static Level level = Level.INFO;

    public static Log getLog(Class<?> clazz) {
        return new LogImpl(clazz);
    }

    public static void resetCorrelationId() {
        CORRELATION_IDS.remove();
    }

    public static void setCorrelationId(String correlationId) {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId");
        String oldCorrelationId = CORRELATION_IDS.get();
        Preconditions.checkState((oldCorrelationId == null || correlationId.contentEquals(oldCorrelationId) ? 1 : 0) != 0, (String)"correlationId: Expected: %s, but was: %s", (Object)oldCorrelationId, (Object)correlationId);
        CORRELATION_IDS.set(correlationId);
    }

    private static String getCorrelationId() {
        String correlationId = CORRELATION_IDS.get();
        if (correlationId == null) {
            IllegalStateException e = new IllegalStateException("correlationId should have been set");
            e.printStackTrace();
            return "????????????????????????????????????";
        }
        return correlationId;
    }

    public static void setLevel(Level level) {
        LogFactory.level = (Level)((Object)Preconditions.checkNotNull((Object)((Object)level), (Object)"level"));
    }

    private static Level getLevel() {
        return level;
    }

    private static class LogImpl
    implements Log {
        private final String prefix;

        LogImpl(Class<?> clazz) {
            Preconditions.checkNotNull(clazz, (Object)"class");
            this.prefix = clazz.getSimpleName() + ": ";
        }

        public void trace(@Nullable Object message) {
            if (!this.isTraceEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.TRACE, this.prefix + message));
        }

        public void trace(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isTraceEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.TRACE, this.prefix + message));
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }

        public void debug(@Nullable Object message) {
            if (!this.isDebugEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.DEBUG, this.prefix + message));
        }

        public void debug(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isDebugEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.DEBUG, this.prefix + message));
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }

        public void info(@Nullable Object message) {
            if (!this.isInfoEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.INFO, this.prefix + message));
        }

        public void info(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isInfoEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.INFO, this.prefix + message));
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }

        public void warn(@Nullable Object message) {
            if (!this.isWarnEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.WARN, this.prefix + message));
        }

        public void warn(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isWarnEnabled()) {
                return;
            }
            System.out.println(LogUtils.format(LogFactory.getCorrelationId(), Level.WARN, this.prefix + message));
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }

        public void error(@Nullable Object message) {
            if (!this.isErrorEnabled()) {
                return;
            }
            System.err.println(LogUtils.format(LogFactory.getCorrelationId(), Level.ERROR, this.prefix + message));
        }

        public void error(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isErrorEnabled()) {
                return;
            }
            System.err.println(LogUtils.format(LogFactory.getCorrelationId(), Level.ERROR, this.prefix + message + ": " + t));
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }

        public void fatal(@Nullable Object message) {
            if (!this.isFatalEnabled()) {
                return;
            }
            System.err.println(LogUtils.format(LogFactory.getCorrelationId(), Level.FATAL, this.prefix + message));
        }

        public void fatal(@Nullable Object message, @Nullable Throwable t) {
            if (!this.isFatalEnabled()) {
                return;
            }
            System.err.println(LogUtils.format(LogFactory.getCorrelationId(), Level.FATAL, this.prefix + message + ": " + t));
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }

        public boolean isDebugEnabled() {
            return !this.getLevel().isGreaterThan(Level.DEBUG);
        }

        public boolean isErrorEnabled() {
            return !this.getLevel().isGreaterThan(Level.ERROR);
        }

        public boolean isFatalEnabled() {
            return !this.getLevel().isGreaterThan(Level.FATAL);
        }

        public boolean isInfoEnabled() {
            return !this.getLevel().isGreaterThan(Level.INFO);
        }

        public boolean isTraceEnabled() {
            return !this.getLevel().isGreaterThan(Level.TRACE);
        }

        public boolean isWarnEnabled() {
            return !this.getLevel().isGreaterThan(Level.WARN);
        }

        private Level getLevel() {
            return LogFactory.getLevel();
        }
    }
}

