/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.testutil;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public abstract class TestUtils {
    public static void assertFileContentEquals(File refFile, File testFile) throws IOException {
        List refLines = FileUtils.readLines((File)refFile, (String)"UTF-8");
        List testLines = FileUtils.readLines((File)testFile, (String)"UTF-8");
        for (int i = 0; i < refLines.size() || i < testLines.size(); ++i) {
            String refLine = (String)refLines.get(i);
            String testLine = (String)testLines.get(i);
            Assert.assertEquals((String)("Line #" + (i + 1)), (Object)refLine, (Object)testLine);
        }
    }

    public static InputStream getResourceAsStream(String resourcePath) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            throw new FileNotFoundException("resourcePath: " + resourcePath);
        }
        return is;
    }

    public static byte[] readResource(String resourcePath) throws IOException {
        Preconditions.checkNotNull((Object)resourcePath, (Object)"resourcePath");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            throw new FileNotFoundException("resourcePath: " + resourcePath);
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static void assertContains(String ref, String[] array) {
        Assert.assertTrue((String)("Array should countain: " + ref + ", but was: " + StringUtils.join((Object[])array, (String)", ")), (boolean)ArrayUtils.contains((Object[])array, (Object)ref));
    }

    public static void assertStartsWith(String ref, String s) {
        Assert.assertTrue((String)("String should start with: " + ref + ", but was: " + s), (boolean)s.startsWith(ref));
    }
}

