/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.core.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class SortBysParser<T extends Enum<?>> {
    private final Class<T> clazz;
    private final Map<String, T> byLowercases = Maps.newHashMap();

    public SortBysParser(Class<T> clazz, T[] values) {
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
        Preconditions.checkNotNull(values, (Object)"values");
        for (T value : values) {
            String name = ((Enum)value).toString();
            Preconditions.checkArgument((boolean)name.startsWith("SORT_BY_"), (String)"SortBy item should start with \"SORT_BY_\", but was: %s", (Object)name);
            String lowercase = name.replace("_", "").toLowerCase(Locale.ENGLISH);
            this.byLowercases.put(lowercase, value);
        }
    }

    @Nullable
    public T[] parse(@Nullable String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        ArrayList sortBys = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean asc = true;
        String trim = s.trim().replace("_", "").toLowerCase(Locale.ENGLISH);
        for (char c : trim.toCharArray()) {
            if (c == '+') {
                if (sb.length() != 0) {
                    this.handleValue(sortBys, asc, sb.toString());
                    sb.setLength(0);
                }
                asc = true;
                continue;
            }
            if (c == '-') {
                if (sb.length() != 0) {
                    this.handleValue(sortBys, asc, sb.toString());
                    sb.setLength(0);
                }
                asc = false;
                continue;
            }
            if (c == ' ' || c == ';' || c == ',' || c == '&') {
                if (sb.length() == 0) continue;
                this.handleValue(sortBys, asc, sb.toString());
                sb.setLength(0);
                asc = true;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() != 0) {
            this.handleValue(sortBys, asc, sb.toString());
        }
        return sortBys.isEmpty() ? null : (Enum[])Iterables.toArray(sortBys, this.clazz);
    }

    private void handleValue(List<T> sortBys, boolean asc, String s) {
        String lowercase = s.endsWith("desc") ? "sortby" + StringUtils.substringBeforeLast((String)s, (String)"desc") + (asc ? "desc" : "") : "sortby" + s + (asc ? "" : "desc");
        Enum value = (Enum)this.byLowercases.get(lowercase);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Unknown SortBy: %s", (Object)lowercase);
        sortBys.add(value);
    }
}

