/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.core.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import net.avcompris.commons3.api.EnumPermission;
import net.avcompris.commons3.api.EnumRole;
import net.avcompris.commons3.api.User;
import net.avcompris.commons3.api.exception.UnauthorizedException;
import net.avcompris.commons3.core.Permissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public final class PermissionsImpl
implements Permissions {
    @Autowired
    public PermissionsImpl() {
    }

    static boolean matches(EnumRole role, CallContext callContext) throws UnauthorizedException {
        for (EnumRole enumRole : role.getSuperRoles()) {
            if (!PermissionsImpl.matches(enumRole, callContext)) continue;
            return true;
        }
        for (EnumRole enumRole : role.getPermissions()) {
            if (!callContext.permissionMatches((EnumPermission)enumRole)) continue;
            return true;
        }
        return false;
    }

    public void assertAuthorized(String correlationId, User user, Object ... contextNameValuePairs) throws UnauthorizedException {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkNotNull((Object)contextNameValuePairs, (Object)"contextNameValuePairs");
        EnumPermission declaredPermissionType = PermissionsImpl.getCurrentServiceMethodDeclaredPermissionType();
        if (declaredPermissionType.isAnyUserPermission()) {
            return;
        }
        String username = user.getUsername();
        CallContext callContext = new CallContext(declaredPermissionType, username, contextNameValuePairs);
        EnumRole role = user.getRole();
        if (PermissionsImpl.matches(role, callContext)) {
            return;
        }
        System.err.println("ERROR *** Could not find permissionType: " + declaredPermissionType + " for username: " + user.getUsername());
        for (EnumRole enumRole : role.getSuperRoles()) {
            System.err.println("    Found: " + user.getUsername() + "/" + enumRole);
        }
        for (EnumRole enumRole : role.getPermissions()) {
            System.err.println("    Found: " + user.getUsername() + "/" + enumRole);
        }
        throw new UnauthorizedException(declaredPermissionType + " (" + username + ")");
    }

    private static EnumPermission getCurrentServiceMethodDeclaredPermissionType() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            Class<?> clazz;
            String className = ste.getClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (clazz.getAnnotation(Service.class) == null) continue;
            String methodName = ste.getMethodName();
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                for (Class<?> i : c.getInterfaces()) {
                    for (Method method : i.getMethods()) {
                        if (!methodName.contentEquals(method.getName())) continue;
                        for (Annotation annotation : method.getAnnotations()) {
                            EnumPermission permissionType = PermissionsImpl.loadAnnotatedPermissionType(annotation);
                            if (permissionType == null) continue;
                            return permissionType;
                        }
                    }
                }
            }
            throw new IllegalStateException("Cannot find @PermissionTypes annotation for: " + className + "." + methodName + "()");
        }
        throw new IllegalStateException("Cannot find @Service + @PermissionTypes annotations for current call.");
    }

    @Nullable
    private static EnumPermission loadAnnotatedPermissionType(Annotation annotation) {
        Method method;
        AnnotatedPermissionType cached = AnnotatedPermissionType.getCached(annotation);
        if (cached != null) {
            return cached.permissionType;
        }
        try {
            method = annotation.annotationType().getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return AnnotatedPermissionType.putNullPermissionTypeFor(annotation);
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == null) {
            return AnnotatedPermissionType.putNullPermissionTypeFor(annotation);
        }
        if (EnumPermission.class.isAssignableFrom(returnType)) {
            EnumPermission permissionType = PermissionsImpl.extractPermissionTypeValueFrom(annotation, method);
            return AnnotatedPermissionType.putPermissionTypeFor(annotation, permissionType);
        }
        if (EnumPermission[].class.isAssignableFrom(returnType)) {
            EnumPermission[] permissionTypes = PermissionsImpl.extractPermissionTypeValuesFrom(annotation, method);
            if (permissionTypes == null || permissionTypes.length == 0) {
                return AnnotatedPermissionType.putNullPermissionTypeFor(annotation);
            }
            Preconditions.checkState((permissionTypes.length == 1 ? 1 : 0) != 0, (String)"PermissionTypes.length should be 1, but was: %s", (int)permissionTypes.length);
            return AnnotatedPermissionType.putPermissionTypeFor(annotation, permissionTypes[0]);
        }
        return AnnotatedPermissionType.putNullPermissionTypeFor(annotation);
    }

    @Nullable
    private static EnumPermission extractPermissionTypeValueFrom(Annotation annotation, Method method) {
        Object result;
        try {
            result = method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
        return (EnumPermission)result;
    }

    @Nullable
    private static EnumPermission[] extractPermissionTypeValuesFrom(Annotation annotation, Method method) {
        Object result;
        try {
            result = method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
        return (EnumPermission[])result;
    }

    private static final class AnnotatedPermissionType {
        private static final AnnotatedPermissionType NULL_INSTANCE = new AnnotatedPermissionType(null);
        private static final Map<Annotation, AnnotatedPermissionType> ANNOTATED_PERMISSION_TYPES = Maps.newHashMap();
        @Nullable
        public final EnumPermission permissionType;

        private AnnotatedPermissionType(@Nullable EnumPermission permissionType) {
            this.permissionType = permissionType;
        }

        @Nullable
        public static AnnotatedPermissionType getCached(Annotation annotation) {
            return ANNOTATED_PERMISSION_TYPES.get(annotation);
        }

        @Nullable
        public static EnumPermission putNullPermissionTypeFor(Annotation annotation) {
            ANNOTATED_PERMISSION_TYPES.put(annotation, NULL_INSTANCE);
            return AnnotatedPermissionType.NULL_INSTANCE.permissionType;
        }

        @Nullable
        public static EnumPermission putPermissionTypeFor(Annotation annotation, @Nullable EnumPermission permissionType) {
            AnnotatedPermissionType annotated = new AnnotatedPermissionType(permissionType);
            ANNOTATED_PERMISSION_TYPES.put(annotation, annotated);
            return permissionType;
        }
    }

    static class CallContext {
        private final EnumPermission declaredPermissionType;
        private final String username;
        private final Object[] contextNameValuePairs;

        CallContext(EnumPermission declaredPermissionType, String username, Object ... contextNameValuePairs) {
            this.declaredPermissionType = (EnumPermission)Preconditions.checkNotNull((Object)declaredPermissionType, (Object)"declaredPermissionType");
            this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
            this.contextNameValuePairs = (Object[])Preconditions.checkNotNull((Object)contextNameValuePairs, (Object)"contextNameValuePairs");
        }

        public boolean permissionMatches(EnumPermission permission) throws UnauthorizedException {
            Preconditions.checkNotNull((Object)permission, (Object)"permission");
            if (permission.isSuperadminPermission()) {
                return true;
            }
            return permission == this.declaredPermissionType;
        }
    }
}

