/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.core.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import javax.annotation.Nullable;
import net.avcompris.commons3.api.EntitiesQuery;
import net.avcompris.commons3.api.exception.DaoException;
import net.avcompris.commons3.api.exception.IllegalStateUpdateException;
import net.avcompris.commons3.api.exception.ServiceException;
import net.avcompris.commons3.core.Permissions;
import net.avcompris.commons3.dao.exception.ForeignEntityViolationException;
import net.avcompris.commons3.utils.Clock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractServiceImpl {
    protected final Permissions permissions;
    protected final Clock clock;
    private static final Log logger = LogFactory.getLog(AbstractServiceImpl.class);

    protected AbstractServiceImpl(Permissions permissions, Clock clock) {
        this.permissions = (Permissions)Preconditions.checkNotNull((Object)permissions, (Object)"permissions");
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
    }

    protected static void wrap(ActionVoid action) throws ServiceException {
        try {
            action.execute();
        }
        catch (ConcurrentModificationException e) {
            throw new IllegalStateUpdateException(e);
        }
        catch (IOException | SQLException e) {
            throw new DaoException((Throwable)e);
        }
    }

    protected static <T> T wrap(Action<T> action) throws ServiceException {
        try {
            return action.execute();
        }
        catch (ConcurrentModificationException e) {
            throw new IllegalStateUpdateException(e);
        }
        catch (IOException | SQLException e) {
            throw new DaoException((Throwable)e);
        }
    }

    protected static void unchecked(ActionVoid action) {
        try {
            action.execute();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected final int getQueryStart(@Nullable EntitiesQuery<?, ?> query, int defaultValue) {
        Integer start = query == null ? null : query.getStart();
        return start != null ? start : defaultValue;
    }

    protected final int getQueryLimit(@Nullable EntitiesQuery<?, ?> query, int defaultValue) {
        Integer limit = query == null ? null : query.getLimit();
        return limit != null ? limit : defaultValue;
    }

    protected static <T> T retryDaoUntil(long timeoutMs, long delayMs, DaoAction<T> action) throws SQLException, IOException, ServiceException {
        return AbstractServiceImpl.retryDaoUntil(timeoutMs, delayMs, true, action);
    }

    protected static <T> T retryDaoWithForeignEntityUntil(long timeoutMs, long delayMs, DaoActionWithForeignEntity<T> action) throws SQLException, IOException, ForeignEntityViolationException {
        return AbstractServiceImpl.retryDaoWithForeignEntityUntil(timeoutMs, delayMs, true, action);
    }

    protected static <T> T retryDaoUntil(long timeoutMs, long delayMs, boolean throwExceptionInCaseOfTimeout, DaoAction<T> action) throws SQLException, IOException, ServiceException {
        Preconditions.checkNotNull(action, (Object)"action");
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs) {
            T result = null;
            try {
                result = action.action();
            }
            catch (IOException | Error | RuntimeException | SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.error((Object)("A timeout occurs (" + timeoutMs + " ms)"));
        if (throwExceptionInCaseOfTimeout) {
            throw new RuntimeException("Timeout after: " + timeoutMs + " ms");
        }
        return null;
    }

    protected static <T> T retryDaoWithForeignEntityUntil(long timeoutMs, long delayMs, boolean throwExceptionInCaseOfTimeout, DaoActionWithForeignEntity<T> action) throws SQLException, IOException, ForeignEntityViolationException {
        Preconditions.checkNotNull(action, (Object)"action");
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs) {
            T result = null;
            try {
                result = action.action();
            }
            catch (IOException | Error | RuntimeException | SQLException | ForeignEntityViolationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.error((Object)("A timeout occurs (" + timeoutMs + " ms)"));
        if (throwExceptionInCaseOfTimeout) {
            throw new RuntimeException("Timeout after: " + timeoutMs + " ms");
        }
        return null;
    }

    @FunctionalInterface
    protected static interface DaoActionWithForeignEntity<T> {
        public T action() throws SQLException, IOException, ForeignEntityViolationException;
    }

    @FunctionalInterface
    protected static interface DaoAction<T> {
        public T action() throws SQLException, IOException, ServiceException;
    }

    @FunctionalInterface
    protected static interface ServiceAction<T> {
        public T execute() throws ServiceException;
    }

    @FunctionalInterface
    protected static interface Action<T> {
        public T execute() throws SQLException, IOException, ServiceException;
    }

    @FunctionalInterface
    protected static interface ActionVoid {
        public void execute() throws SQLException, IOException, ServiceException;
    }
}

