/*
 * Decompiled with CFR 0.152.
 */
package net.avcompris.commons3.core;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.avcompris.commons3.types.DateTimeHolder;
import org.apache.commons.lang3.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTimeHolderImpl
implements DateTimeHolder {
    private static final long serialVersionUID = 1160765887175893130L;
    private static final DateTimeFormatter ISO_FORMATTER = ISODateTimeFormat.dateTime();
    private final DateTime dateTime;
    private final String text;
    private final long ms;

    private DateTimeHolderImpl(DateTime dateTime) {
        this.dateTime = (DateTime)Preconditions.checkNotNull((Object)dateTime, (Object)"dateTime");
        this.text = dateTime.withZone(DateTimeZone.UTC).toString(ISO_FORMATTER);
        this.ms = dateTime.getMillis();
    }

    @Nullable
    public static DateTimeHolder toDateTimeHolderOrNull(@Nullable DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeHolderImpl.toDateTimeHolder(dateTime);
    }

    @Nullable
    public static DateTimeHolder toDateTimeHolder(DateTime dateTime) {
        Preconditions.checkNotNull((Object)dateTime, (Object)"dateTime");
        return new DateTimeHolderImpl(dateTime);
    }

    @Nullable
    public static DateTimeHolder toDateTimeHolder(long timestamp) {
        return new DateTimeHolderImpl(new DateTime(timestamp).withZone(DateTimeZone.UTC));
    }

    public String getDateTime() {
        return this.text;
    }

    public long getTimestamp() {
        return this.ms;
    }

    public String toString() {
        return "{dateTime: \"" + this.text + "\", timestamp: " + this.ms + "}";
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof DateTimeHolder)) {
            return false;
        }
        return this.toString().contentEquals(o.toString());
    }

    public static DateTime toDateTimeOrNull(@Nullable DateTimeHolder holder) {
        if (holder == null) {
            return null;
        }
        return DateTimeHolderImpl.toDateTime(holder);
    }

    public static DateTime toDateTime(DateTimeHolder holder) {
        Preconditions.checkNotNull((Object)holder, (Object)"holder");
        Preconditions.checkArgument((boolean)(holder instanceof DateTimeHolderImpl), (String)"holder should be of type %s, but was: %s", (Object)DateTimeHolderImpl.class.getName(), (Object)holder.getClass().getName());
        return ((DateTimeHolderImpl)holder).dateTime;
    }

    public int compareTo(@Nullable DateTimeHolder d) {
        if (d == null) {
            return this.dateTime.compareTo(null);
        }
        if (d instanceof DateTimeHolderImpl) {
            return this.dateTime.compareTo((ReadableInstant)((DateTimeHolderImpl)d).dateTime);
        }
        throw new NotImplementedException("d.class: " + d.getClass().getName());
    }

    public Object clone() {
        return DateTimeHolderImpl.toDateTimeHolder(this.dateTime);
    }
}

