/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK.api.EInvoicing.V1;

import Avalara.SDK.ApiCallback;
import Avalara.SDK.ApiClient;
import Avalara.SDK.ApiException;
import Avalara.SDK.ApiResponse;
import Avalara.SDK.AvalaraMicroservice;
import Avalara.SDK.Pair;
import Avalara.SDK.model.EInvoicing.V1.BatchSearch;
import Avalara.SDK.model.EInvoicing.V1.BatchSearchListResponse;
import Avalara.SDK.model.EInvoicing.V1.BatchSearchParticipants202Response;
import Avalara.SDK.model.EInvoicing.V1.CreateTradingPartner201Response;
import Avalara.SDK.model.EInvoicing.V1.CreateTradingPartnersBatch200Response;
import Avalara.SDK.model.EInvoicing.V1.SearchParticipants200Response;
import Avalara.SDK.model.EInvoicing.V1.TradingPartner;
import Avalara.SDK.model.EInvoicing.V1.UpdateTradingPartner200Response;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingFormatArgumentException;
import okhttp3.Call;

public class TradingPartnersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TradingPartnersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.SetConfiguration(apiClient);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call batchSearchParticipantsCall(BatchSearchParticipantsRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners/batch-searches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.get_file() != null) {
            localVarFormParams.put("file", requestParameters.get_file());
        }
        if (requestParameters.getName() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", requestParameters.getName()));
        }
        if (requestParameters.getNotificationEmail() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("notificationEmail", requestParameters.getNotificationEmail()));
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call batchSearchParticipantsValidateBeforeCall(BatchSearchParticipantsRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling batchSearchParticipants(Async)");
        }
        if (requestParameters.getName() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.name' when calling batchSearchParticipants(Async)");
        }
        if (requestParameters.getNotificationEmail() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.notificationEmail' when calling batchSearchParticipants(Async)");
        }
        if (requestParameters.get_file() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters._file' when calling batchSearchParticipants(Async)");
        }
        Call localVarCall = this.batchSearchParticipantsCall(requestParameters, _callback);
        return localVarCall;
    }

    public BatchSearchParticipants202Response batchSearchParticipants(BatchSearchParticipantsRequest requestParameters) throws ApiException {
        ApiResponse<BatchSearchParticipants202Response> localVarResp = this.batchSearchParticipantsWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<BatchSearchParticipants202Response> batchSearchParticipantsWithHttpInfo(BatchSearchParticipantsRequest requestParameters) throws ApiException {
        Call localVarCall = this.batchSearchParticipantsValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<BatchSearchParticipants202Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call batchSearchParticipantsAsync(BatchSearchParticipantsRequest requestParameters, ApiCallback<BatchSearchParticipants202Response> _callback) throws ApiException {
        Call localVarCall = this.batchSearchParticipantsValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<BatchSearchParticipants202Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BatchSearchParticipantsRequest getBatchSearchParticipantsRequest() {
        return new BatchSearchParticipantsRequest();
    }

    public Call createTradingPartnerCall(CreateTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TradingPartner localVarPostBody = requestParameters.getTradingPartner();
        String localVarPath = "/einvoicing/trading-partners";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call createTradingPartnerValidateBeforeCall(CreateTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling createTradingPartner(Async)");
        }
        if (requestParameters.getTradingPartner() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.tradingPartner' when calling createTradingPartner(Async)");
        }
        Call localVarCall = this.createTradingPartnerCall(requestParameters, _callback);
        return localVarCall;
    }

    public CreateTradingPartner201Response createTradingPartner(CreateTradingPartnerRequest requestParameters) throws ApiException {
        ApiResponse<CreateTradingPartner201Response> localVarResp = this.createTradingPartnerWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<CreateTradingPartner201Response> createTradingPartnerWithHttpInfo(CreateTradingPartnerRequest requestParameters) throws ApiException {
        Call localVarCall = this.createTradingPartnerValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<CreateTradingPartner201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTradingPartnerAsync(CreateTradingPartnerRequest requestParameters, ApiCallback<CreateTradingPartner201Response> _callback) throws ApiException {
        Call localVarCall = this.createTradingPartnerValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<CreateTradingPartner201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateTradingPartnerRequest getCreateTradingPartnerRequest() {
        return new CreateTradingPartnerRequest();
    }

    public Call createTradingPartnersBatchCall(CreateTradingPartnersBatchRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTradingPartnersBatchRequest localVarPostBody = requestParameters.getCreateTradingPartnersBatchRequest();
        String localVarPath = "/einvoicing/trading-partners/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call createTradingPartnersBatchValidateBeforeCall(CreateTradingPartnersBatchRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling createTradingPartnersBatch(Async)");
        }
        if (requestParameters.getCreateTradingPartnersBatchRequest() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.createTradingPartnersBatchRequest' when calling createTradingPartnersBatch(Async)");
        }
        Call localVarCall = this.createTradingPartnersBatchCall(requestParameters, _callback);
        return localVarCall;
    }

    public CreateTradingPartnersBatch200Response createTradingPartnersBatch(CreateTradingPartnersBatchRequest requestParameters) throws ApiException {
        ApiResponse<CreateTradingPartnersBatch200Response> localVarResp = this.createTradingPartnersBatchWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<CreateTradingPartnersBatch200Response> createTradingPartnersBatchWithHttpInfo(CreateTradingPartnersBatchRequest requestParameters) throws ApiException {
        Call localVarCall = this.createTradingPartnersBatchValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<CreateTradingPartnersBatch200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTradingPartnersBatchAsync(CreateTradingPartnersBatchRequest requestParameters, ApiCallback<CreateTradingPartnersBatch200Response> _callback) throws ApiException {
        Call localVarCall = this.createTradingPartnersBatchValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<CreateTradingPartnersBatch200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateTradingPartnersBatchRequest getCreateTradingPartnersBatchRequest() {
        return new CreateTradingPartnersBatchRequest();
    }

    public Call deleteTradingPartnerCall(DeleteTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call deleteTradingPartnerValidateBeforeCall(DeleteTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling deleteTradingPartner(Async)");
        }
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling deleteTradingPartner(Async)");
        }
        Call localVarCall = this.deleteTradingPartnerCall(requestParameters, _callback);
        return localVarCall;
    }

    public void deleteTradingPartner(DeleteTradingPartnerRequest requestParameters) throws ApiException {
        this.deleteTradingPartnerWithHttpInfo(requestParameters);
    }

    public ApiResponse<Void> deleteTradingPartnerWithHttpInfo(DeleteTradingPartnerRequest requestParameters) throws ApiException {
        Call localVarCall = this.deleteTradingPartnerValidateBeforeCall(requestParameters, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTradingPartnerAsync(DeleteTradingPartnerRequest requestParameters, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTradingPartnerValidateBeforeCall(requestParameters, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteTradingPartnerRequest getDeleteTradingPartnerRequest() {
        return new DeleteTradingPartnerRequest();
    }

    public Call downloadBatchSearchReportCall(DownloadBatchSearchReportRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners/batch-searches/{id}/$download-results".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/csv", "application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call downloadBatchSearchReportValidateBeforeCall(DownloadBatchSearchReportRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling downloadBatchSearchReport(Async)");
        }
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling downloadBatchSearchReport(Async)");
        }
        Call localVarCall = this.downloadBatchSearchReportCall(requestParameters, _callback);
        return localVarCall;
    }

    public File downloadBatchSearchReport(DownloadBatchSearchReportRequest requestParameters) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadBatchSearchReportWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadBatchSearchReportWithHttpInfo(DownloadBatchSearchReportRequest requestParameters) throws ApiException {
        Call localVarCall = this.downloadBatchSearchReportValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadBatchSearchReportAsync(DownloadBatchSearchReportRequest requestParameters, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadBatchSearchReportValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DownloadBatchSearchReportRequest getDownloadBatchSearchReportRequest() {
        return new DownloadBatchSearchReportRequest();
    }

    public Call getBatchSearchDetailCall(GetBatchSearchDetailRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners/batch-searches/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call getBatchSearchDetailValidateBeforeCall(GetBatchSearchDetailRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getBatchSearchDetail(Async)");
        }
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling getBatchSearchDetail(Async)");
        }
        Call localVarCall = this.getBatchSearchDetailCall(requestParameters, _callback);
        return localVarCall;
    }

    public BatchSearch getBatchSearchDetail(GetBatchSearchDetailRequest requestParameters) throws ApiException {
        ApiResponse<BatchSearch> localVarResp = this.getBatchSearchDetailWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<BatchSearch> getBatchSearchDetailWithHttpInfo(GetBatchSearchDetailRequest requestParameters) throws ApiException {
        Call localVarCall = this.getBatchSearchDetailValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<BatchSearch>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchSearchDetailAsync(GetBatchSearchDetailRequest requestParameters, ApiCallback<BatchSearch> _callback) throws ApiException {
        Call localVarCall = this.getBatchSearchDetailValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<BatchSearch>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBatchSearchDetailRequest getGetBatchSearchDetailRequest() {
        return new GetBatchSearchDetailRequest();
    }

    public Call listBatchSearchesCall(ListBatchSearchesRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners/batch-searches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.get$filter() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$filter", requestParameters.get$filter()));
        }
        if (requestParameters.getCount() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", requestParameters.getCount()));
        }
        if (requestParameters.get$top() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$top", requestParameters.get$top()));
        }
        if (requestParameters.get$skip() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$skip", requestParameters.get$skip()));
        }
        if (requestParameters.get$orderBy() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$orderBy", requestParameters.get$orderBy()));
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call listBatchSearchesValidateBeforeCall(ListBatchSearchesRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling listBatchSearches(Async)");
        }
        Call localVarCall = this.listBatchSearchesCall(requestParameters, _callback);
        return localVarCall;
    }

    public BatchSearchListResponse listBatchSearches(ListBatchSearchesRequest requestParameters) throws ApiException {
        ApiResponse<BatchSearchListResponse> localVarResp = this.listBatchSearchesWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<BatchSearchListResponse> listBatchSearchesWithHttpInfo(ListBatchSearchesRequest requestParameters) throws ApiException {
        Call localVarCall = this.listBatchSearchesValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<BatchSearchListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listBatchSearchesAsync(ListBatchSearchesRequest requestParameters, ApiCallback<BatchSearchListResponse> _callback) throws ApiException {
        Call localVarCall = this.listBatchSearchesValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<BatchSearchListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ListBatchSearchesRequest getListBatchSearchesRequest() {
        return new ListBatchSearchesRequest();
    }

    public Call searchParticipantsCall(SearchParticipantsRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/trading-partners";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getCount() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", requestParameters.getCount()));
        }
        if (requestParameters.get$search() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$search", requestParameters.get$search()));
        }
        if (requestParameters.get$filter() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$filter", requestParameters.get$filter()));
        }
        if (requestParameters.get$top() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$top", requestParameters.get$top()));
        }
        if (requestParameters.get$skip() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$skip", requestParameters.get$skip()));
        }
        if (requestParameters.get$orderBy() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$orderBy", requestParameters.get$orderBy()));
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call searchParticipantsValidateBeforeCall(SearchParticipantsRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling searchParticipants(Async)");
        }
        if (requestParameters.get$search() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.$search' when calling searchParticipants(Async)");
        }
        Call localVarCall = this.searchParticipantsCall(requestParameters, _callback);
        return localVarCall;
    }

    public SearchParticipants200Response searchParticipants(SearchParticipantsRequest requestParameters) throws ApiException {
        ApiResponse<SearchParticipants200Response> localVarResp = this.searchParticipantsWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<SearchParticipants200Response> searchParticipantsWithHttpInfo(SearchParticipantsRequest requestParameters) throws ApiException {
        Call localVarCall = this.searchParticipantsValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<SearchParticipants200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call searchParticipantsAsync(SearchParticipantsRequest requestParameters, ApiCallback<SearchParticipants200Response> _callback) throws ApiException {
        Call localVarCall = this.searchParticipantsValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<SearchParticipants200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SearchParticipantsRequest getSearchParticipantsRequest() {
        return new SearchParticipantsRequest();
    }

    public Call updateTradingPartnerCall(UpdateTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TradingPartner localVarPostBody = requestParameters.getTradingPartner();
        String localVarPath = "/einvoicing/trading-partners/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if (requestParameters.getXCorrelationID() != null) {
            localVarHeaderParams.put("X-Correlation-ID", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationID()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call updateTradingPartnerValidateBeforeCall(UpdateTradingPartnerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling updateTradingPartner(Async)");
        }
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling updateTradingPartner(Async)");
        }
        if (requestParameters.getTradingPartner() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.tradingPartner' when calling updateTradingPartner(Async)");
        }
        Call localVarCall = this.updateTradingPartnerCall(requestParameters, _callback);
        return localVarCall;
    }

    public UpdateTradingPartner200Response updateTradingPartner(UpdateTradingPartnerRequest requestParameters) throws ApiException {
        ApiResponse<UpdateTradingPartner200Response> localVarResp = this.updateTradingPartnerWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<UpdateTradingPartner200Response> updateTradingPartnerWithHttpInfo(UpdateTradingPartnerRequest requestParameters) throws ApiException {
        Call localVarCall = this.updateTradingPartnerValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<UpdateTradingPartner200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTradingPartnerAsync(UpdateTradingPartnerRequest requestParameters, ApiCallback<UpdateTradingPartner200Response> _callback) throws ApiException {
        Call localVarCall = this.updateTradingPartnerValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<UpdateTradingPartner200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateTradingPartnerRequest getUpdateTradingPartnerRequest() {
        return new UpdateTradingPartnerRequest();
    }

    private void SetConfiguration(ApiClient client) {
        if (client == null) {
            throw new MissingFormatArgumentException("client");
        }
        this.localVarApiClient.setSdkVersion("25.8.3");
    }

    public class UpdateTradingPartnerRequest {
        private String avalaraVersion;
        private String id;
        private TradingPartner tradingPartner;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public TradingPartner getTradingPartner() {
            return this.tradingPartner;
        }

        public void setTradingPartner(TradingPartner tradingPartner) {
            this.tradingPartner = tradingPartner;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class SearchParticipantsRequest {
        private String avalaraVersion;
        private String $search;
        private String xAvalaraClient;
        private Boolean count;
        private String $filter;
        private Integer $top;
        private Integer $skip;
        private String $orderBy;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String get$search() {
            return this.$search;
        }

        public void set$search(String $search) {
            this.$search = $search;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public Boolean getCount() {
            return this.count;
        }

        public void setCount(Boolean count) {
            this.count = count;
        }

        public String get$filter() {
            return this.$filter;
        }

        public void set$filter(String $filter) {
            this.$filter = $filter;
        }

        public Integer get$top() {
            return this.$top;
        }

        public void set$top(Integer $top) {
            this.$top = $top;
        }

        public Integer get$skip() {
            return this.$skip;
        }

        public void set$skip(Integer $skip) {
            this.$skip = $skip;
        }

        public String get$orderBy() {
            return this.$orderBy;
        }

        public void set$orderBy(String $orderBy) {
            this.$orderBy = $orderBy;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class ListBatchSearchesRequest {
        private String avalaraVersion;
        private String xAvalaraClient;
        private String $filter;
        private Boolean count;
        private Integer $top;
        private Integer $skip;
        private String $orderBy;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String get$filter() {
            return this.$filter;
        }

        public void set$filter(String $filter) {
            this.$filter = $filter;
        }

        public Boolean getCount() {
            return this.count;
        }

        public void setCount(Boolean count) {
            this.count = count;
        }

        public Integer get$top() {
            return this.$top;
        }

        public void set$top(Integer $top) {
            this.$top = $top;
        }

        public Integer get$skip() {
            return this.$skip;
        }

        public void set$skip(Integer $skip) {
            this.$skip = $skip;
        }

        public String get$orderBy() {
            return this.$orderBy;
        }

        public void set$orderBy(String $orderBy) {
            this.$orderBy = $orderBy;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class GetBatchSearchDetailRequest {
        private String avalaraVersion;
        private String id;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class DownloadBatchSearchReportRequest {
        private String avalaraVersion;
        private String id;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class DeleteTradingPartnerRequest {
        private String avalaraVersion;
        private String id;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class CreateTradingPartnersBatchRequest {
        private String avalaraVersion;
        private CreateTradingPartnersBatchRequest createTradingPartnersBatchRequest;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public CreateTradingPartnersBatchRequest getCreateTradingPartnersBatchRequest() {
            return this.createTradingPartnersBatchRequest;
        }

        public void setCreateTradingPartnersBatchRequest(CreateTradingPartnersBatchRequest createTradingPartnersBatchRequest) {
            this.createTradingPartnersBatchRequest = createTradingPartnersBatchRequest;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class CreateTradingPartnerRequest {
        private String avalaraVersion;
        private TradingPartner tradingPartner;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public TradingPartner getTradingPartner() {
            return this.tradingPartner;
        }

        public void setTradingPartner(TradingPartner tradingPartner) {
            this.tradingPartner = tradingPartner;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }

    public class BatchSearchParticipantsRequest {
        private String avalaraVersion;
        private String name;
        private String notificationEmail;
        private File _file;
        private String xAvalaraClient;
        private String xCorrelationID;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNotificationEmail() {
            return this.notificationEmail;
        }

        public void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        public File get_file() {
            return this._file;
        }

        public void set_file(File _file) {
            this._file = _file;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public String getXCorrelationID() {
            return this.xCorrelationID;
        }

        public void setXCorrelationID(String xCorrelationID) {
            this.xCorrelationID = xCorrelationID;
        }
    }
}

