/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK.api.EInvoicing.V1;

import Avalara.SDK.ApiCallback;
import Avalara.SDK.ApiClient;
import Avalara.SDK.ApiException;
import Avalara.SDK.ApiResponse;
import Avalara.SDK.AvalaraMicroservice;
import Avalara.SDK.Pair;
import Avalara.SDK.model.EInvoicing.V1.DocumentFetch;
import Avalara.SDK.model.EInvoicing.V1.DocumentListResponse;
import Avalara.SDK.model.EInvoicing.V1.DocumentStatusResponse;
import Avalara.SDK.model.EInvoicing.V1.DocumentSubmitResponse;
import Avalara.SDK.model.EInvoicing.V1.SubmitDocumentMetadata;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingFormatArgumentException;
import okhttp3.Call;

public class DocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.SetConfiguration(apiClient);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call downloadDocumentCall(DownloadDocumentRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/documents/{documentId}/$download".replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(requestParameters.documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getAccept() != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(requestParameters.getAccept()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/pdf", "application/xml", "application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call downloadDocumentValidateBeforeCall(DownloadDocumentRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling downloadDocument(Async)");
        }
        if (requestParameters.getAccept() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.accept' when calling downloadDocument(Async)");
        }
        if (requestParameters.getDocumentId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.documentId' when calling downloadDocument(Async)");
        }
        Call localVarCall = this.downloadDocumentCall(requestParameters, _callback);
        return localVarCall;
    }

    public File downloadDocument(DownloadDocumentRequest requestParameters) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadDocumentWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadDocumentWithHttpInfo(DownloadDocumentRequest requestParameters) throws ApiException {
        Call localVarCall = this.downloadDocumentValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadDocumentAsync(DownloadDocumentRequest requestParameters, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadDocumentValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DownloadDocumentRequest getDownloadDocumentRequest() {
        return new DownloadDocumentRequest();
    }

    public Call fetchDocumentsCall(FetchDocumentsRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FetchDocumentsRequest localVarPostBody = requestParameters.getFetchDocumentsRequest();
        String localVarPath = "/einvoicing/documents/$fetch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call fetchDocumentsValidateBeforeCall(FetchDocumentsRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling fetchDocuments(Async)");
        }
        if (requestParameters.getFetchDocumentsRequest() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.fetchDocumentsRequest' when calling fetchDocuments(Async)");
        }
        Call localVarCall = this.fetchDocumentsCall(requestParameters, _callback);
        return localVarCall;
    }

    public DocumentFetch fetchDocuments(FetchDocumentsRequest requestParameters) throws ApiException {
        ApiResponse<DocumentFetch> localVarResp = this.fetchDocumentsWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentFetch> fetchDocumentsWithHttpInfo(FetchDocumentsRequest requestParameters) throws ApiException {
        Call localVarCall = this.fetchDocumentsValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<DocumentFetch>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call fetchDocumentsAsync(FetchDocumentsRequest requestParameters, ApiCallback<DocumentFetch> _callback) throws ApiException {
        Call localVarCall = this.fetchDocumentsValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<DocumentFetch>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public FetchDocumentsRequest getFetchDocumentsRequest() {
        return new FetchDocumentsRequest();
    }

    public Call getDocumentListCall(GetDocumentListRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getStartDate() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", requestParameters.getStartDate()));
        }
        if (requestParameters.getEndDate() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", requestParameters.getEndDate()));
        }
        if (requestParameters.getFlow() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flow", requestParameters.getFlow()));
        }
        if (requestParameters.get$count() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$count", requestParameters.get$count()));
        }
        if (requestParameters.get$countOnly() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$countOnly", requestParameters.get$countOnly()));
        }
        if (requestParameters.get$filter() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$filter", requestParameters.get$filter()));
        }
        if (requestParameters.get$top() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$top", requestParameters.get$top()));
        }
        if (requestParameters.get$skip() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$skip", requestParameters.get$skip()));
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call getDocumentListValidateBeforeCall(GetDocumentListRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getDocumentList(Async)");
        }
        Call localVarCall = this.getDocumentListCall(requestParameters, _callback);
        return localVarCall;
    }

    public DocumentListResponse getDocumentList(GetDocumentListRequest requestParameters) throws ApiException {
        ApiResponse<DocumentListResponse> localVarResp = this.getDocumentListWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentListResponse> getDocumentListWithHttpInfo(GetDocumentListRequest requestParameters) throws ApiException {
        Call localVarCall = this.getDocumentListValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<DocumentListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentListAsync(GetDocumentListRequest requestParameters, ApiCallback<DocumentListResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentListValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<DocumentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDocumentListRequest getGetDocumentListRequest() {
        return new GetDocumentListRequest();
    }

    public Call getDocumentStatusCall(GetDocumentStatusRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/documents/{documentId}/status".replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(requestParameters.documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call getDocumentStatusValidateBeforeCall(GetDocumentStatusRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getDocumentStatus(Async)");
        }
        if (requestParameters.getDocumentId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.documentId' when calling getDocumentStatus(Async)");
        }
        Call localVarCall = this.getDocumentStatusCall(requestParameters, _callback);
        return localVarCall;
    }

    public DocumentStatusResponse getDocumentStatus(GetDocumentStatusRequest requestParameters) throws ApiException {
        ApiResponse<DocumentStatusResponse> localVarResp = this.getDocumentStatusWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentStatusResponse> getDocumentStatusWithHttpInfo(GetDocumentStatusRequest requestParameters) throws ApiException {
        Call localVarCall = this.getDocumentStatusValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<DocumentStatusResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDocumentStatusAsync(GetDocumentStatusRequest requestParameters, ApiCallback<DocumentStatusResponse> _callback) throws ApiException {
        Call localVarCall = this.getDocumentStatusValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<DocumentStatusResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDocumentStatusRequest getGetDocumentStatusRequest() {
        return new GetDocumentStatusRequest();
    }

    public Call submitDocumentCall(SubmitDocumentRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/einvoicing/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getMetadata() != null) {
            localVarFormParams.put("metadata", requestParameters.getMetadata());
        }
        if (requestParameters.getData() != null) {
            localVarFormParams.put("data", requestParameters.getData());
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "text/xml"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "Bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.EInvoicing);
    }

    private Call submitDocumentValidateBeforeCall(SubmitDocumentRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling submitDocument(Async)");
        }
        if (requestParameters.getMetadata() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.metadata' when calling submitDocument(Async)");
        }
        if (requestParameters.getData() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.data' when calling submitDocument(Async)");
        }
        Call localVarCall = this.submitDocumentCall(requestParameters, _callback);
        return localVarCall;
    }

    public DocumentSubmitResponse submitDocument(SubmitDocumentRequest requestParameters) throws ApiException {
        ApiResponse<DocumentSubmitResponse> localVarResp = this.submitDocumentWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentSubmitResponse> submitDocumentWithHttpInfo(SubmitDocumentRequest requestParameters) throws ApiException {
        Call localVarCall = this.submitDocumentValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<DocumentSubmitResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitDocumentAsync(SubmitDocumentRequest requestParameters, ApiCallback<DocumentSubmitResponse> _callback) throws ApiException {
        Call localVarCall = this.submitDocumentValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<DocumentSubmitResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SubmitDocumentRequest getSubmitDocumentRequest() {
        return new SubmitDocumentRequest();
    }

    private void SetConfiguration(ApiClient client) {
        if (client == null) {
            throw new MissingFormatArgumentException("client");
        }
        this.localVarApiClient.setSdkVersion("25.8.3");
    }

    public class SubmitDocumentRequest {
        private String avalaraVersion;
        private SubmitDocumentMetadata metadata;
        private Object data;
        private String xAvalaraClient;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public SubmitDocumentMetadata getMetadata() {
            return this.metadata;
        }

        public void setMetadata(SubmitDocumentMetadata metadata) {
            this.metadata = metadata;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class GetDocumentStatusRequest {
        private String avalaraVersion;
        private String documentId;
        private String xAvalaraClient;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class GetDocumentListRequest {
        private String avalaraVersion;
        private String xAvalaraClient;
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;
        private String flow;
        private String $count;
        private String $countOnly;
        private String $filter;
        private Integer $top;
        private Integer $skip;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public OffsetDateTime getStartDate() {
            return this.startDate;
        }

        public void setStartDate(OffsetDateTime startDate) {
            this.startDate = startDate;
        }

        public OffsetDateTime getEndDate() {
            return this.endDate;
        }

        public void setEndDate(OffsetDateTime endDate) {
            this.endDate = endDate;
        }

        public String getFlow() {
            return this.flow;
        }

        public void setFlow(String flow) {
            this.flow = flow;
        }

        public String get$count() {
            return this.$count;
        }

        public void set$count(String $count) {
            this.$count = $count;
        }

        public String get$countOnly() {
            return this.$countOnly;
        }

        public void set$countOnly(String $countOnly) {
            this.$countOnly = $countOnly;
        }

        public String get$filter() {
            return this.$filter;
        }

        public void set$filter(String $filter) {
            this.$filter = $filter;
        }

        public Integer get$top() {
            return this.$top;
        }

        public void set$top(Integer $top) {
            this.$top = $top;
        }

        public Integer get$skip() {
            return this.$skip;
        }

        public void set$skip(Integer $skip) {
            this.$skip = $skip;
        }
    }

    public class FetchDocumentsRequest {
        private String avalaraVersion;
        private FetchDocumentsRequest fetchDocumentsRequest;
        private String xAvalaraClient;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public FetchDocumentsRequest getFetchDocumentsRequest() {
            return this.fetchDocumentsRequest;
        }

        public void setFetchDocumentsRequest(FetchDocumentsRequest fetchDocumentsRequest) {
            this.fetchDocumentsRequest = fetchDocumentsRequest;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class DownloadDocumentRequest {
        private String avalaraVersion;
        private String accept;
        private String documentId;
        private String xAvalaraClient;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "1.4";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }
}

