/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK.api.A1099.V2;

import Avalara.SDK.ApiCallback;
import Avalara.SDK.ApiClient;
import Avalara.SDK.ApiException;
import Avalara.SDK.ApiResponse;
import Avalara.SDK.AvalaraMicroservice;
import Avalara.SDK.Pair;
import Avalara.SDK.model.A1099.V2.JobResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingFormatArgumentException;
import okhttp3.Call;

public class JobsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public JobsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.SetConfiguration(apiClient);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getJobCall(GetJobRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/jobs/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null && !localVarHeaderParams.containsKey("Accept")) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call getJobValidateBeforeCall(GetJobRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling getJob(Async)");
        }
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getJob(Async)");
        }
        Call localVarCall = this.getJobCall(requestParameters, _callback);
        return localVarCall;
    }

    public JobResponse getJob(GetJobRequest requestParameters) throws ApiException {
        ApiResponse<JobResponse> localVarResp = this.getJobWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<JobResponse> getJobWithHttpInfo(GetJobRequest requestParameters) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<JobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobAsync(GetJobRequest requestParameters, ApiCallback<JobResponse> _callback) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<JobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetJobRequest getGetJobRequest() {
        return new GetJobRequest();
    }

    private void SetConfiguration(ApiClient client) {
        if (client == null) {
            throw new MissingFormatArgumentException("client");
        }
        this.localVarApiClient.setSdkVersion("25.8.3");
    }

    public class GetJobRequest {
        private String id;
        private String avalaraVersion;
        private String xCorrelationId;
        private String xAvalaraClient;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }
}

