/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK;

import Avalara.SDK.AvaTaxEnvironment;
import Avalara.SDK.AvalaraMicroservice;

public class Configuration {
    private static final String AVALARA_DEV_URL = "https://superapi.dev.avalara.io";
    private static final String AVALARA_QA_URL = "https://superapi.qa.avalara.io";
    private static final String AVALARA_SANDBOX_URL = "https://api.sbx.avalara.com";
    private static final String AVALARA_PRODUCTION_URL = "https://api.avalara.com";
    private static final String TRACK1099_SERVICE_DEV_URL = "https://api-ava1099.gamma.dev.us-west-2.aws.avalara.io";
    private static final String TRACK1099_SERVICE_QA_URL = "https://api-ava1099.gamma.qa.us-west-2.aws.avalara.io";
    private static final String TRACK1099_SERVICE_SBX_URL = "https://api.sbx.avalara.com/avalara1099";
    private static final String TRACK1099_SERVICE_PRD_URL = "https://api.avalara.com/avalara1099";
    private String Username;
    private String Password;
    private String BearerToken;
    private AvaTaxEnvironment Environment;
    private int Timeout = 10000;
    private String AppName;
    private String AppVersion;
    private String MachineName;
    private String TestBasePath;
    private String tokenUrl;
    private String deviceAuthorizationUrl;
    private String ClientId;

    public String getUsername() {
        return this.Username;
    }

    public void setUsername(String username) {
        this.Username = username;
    }

    public String getPassword() {
        return this.Password;
    }

    public void setPassword(String password) {
        this.Password = password;
    }

    public String getBearerToken() {
        return this.BearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.BearerToken = bearerToken;
    }

    public AvaTaxEnvironment getEnvironment() {
        return this.Environment;
    }

    public void setEnvironment(AvaTaxEnvironment environment) {
        this.Environment = environment;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public void setTimeout(int timeout) {
        this.Timeout = timeout;
    }

    public String getAppName() {
        return this.AppName;
    }

    public void setAppName(String appName) {
        this.AppName = appName;
    }

    public String getAppVersion() {
        return this.AppVersion;
    }

    public void setAppVersion(String appVersion) {
        this.AppVersion = appVersion;
    }

    public String getMachineName() {
        return this.MachineName;
    }

    public void setMachineName(String machineName) {
        this.MachineName = machineName;
    }

    public String getTestBasePath() {
        return this.TestBasePath;
    }

    public void setTestBasePath(String testBasePath) {
        this.TestBasePath = testBasePath;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getDeviceAuthorizationUrl() {
        return this.deviceAuthorizationUrl;
    }

    public void setDeviceAuthorizationUrl(String deviceAuthorizationUrl) {
        this.deviceAuthorizationUrl = deviceAuthorizationUrl;
    }

    public String getClientId() {
        return this.ClientId;
    }

    public void setClientId(String clientId) {
        this.ClientId = clientId;
    }

    public String getBasePath(AvalaraMicroservice microservice) {
        switch (microservice) {
            case EInvoicing: {
                switch (this.getEnvironment()) {
                    case Production: {
                        return AVALARA_PRODUCTION_URL;
                    }
                    case Sandbox: {
                        return AVALARA_SANDBOX_URL;
                    }
                    case QA: {
                        return AVALARA_QA_URL;
                    }
                    case DEV: {
                        return AVALARA_DEV_URL;
                    }
                    case Test: {
                        if (this.getTestBasePath() == null) {
                            throw new NullPointerException("When Environment is set to 'Test', the Test URL is a required parameter.");
                        }
                        return this.getTestBasePath();
                    }
                }
                throw new Error("Environment does not match any base path.");
            }
            case A1099: {
                switch (this.getEnvironment()) {
                    case Production: {
                        return TRACK1099_SERVICE_PRD_URL;
                    }
                    case Sandbox: {
                        return TRACK1099_SERVICE_SBX_URL;
                    }
                    case QA: {
                        return TRACK1099_SERVICE_QA_URL;
                    }
                    case DEV: {
                        return TRACK1099_SERVICE_DEV_URL;
                    }
                    case Test: {
                        if (this.getTestBasePath() == null) {
                            throw new NullPointerException("When Environment is set to 'Test', the Test URL is a required parameter.");
                        }
                        return this.getTestBasePath();
                    }
                }
                throw new Error("Environment does not match any base path.");
            }
        }
        throw new Error("Microservice does not match any base path.");
    }
}

