/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK.api.A1099.V2;

import Avalara.SDK.ApiCallback;
import Avalara.SDK.ApiClient;
import Avalara.SDK.ApiException;
import Avalara.SDK.ApiResponse;
import Avalara.SDK.AvalaraMicroservice;
import Avalara.SDK.Pair;
import Avalara.SDK.model.A1099.V2.IssuerCommand;
import Avalara.SDK.model.A1099.V2.IssuerResponse;
import Avalara.SDK.model.A1099.V2.PaginatedQueryResultModelIssuerResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingFormatArgumentException;
import okhttp3.Call;

public class Issuers1099Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public Issuers1099Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.SetConfiguration(apiClient);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIssuerCall(CreateIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IssuerCommand localVarPostBody = requestParameters.getIssuerCommand();
        String localVarPath = "/1099/issuers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call createIssuerValidateBeforeCall(CreateIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling createIssuer(Async)");
        }
        Call localVarCall = this.createIssuerCall(requestParameters, _callback);
        return localVarCall;
    }

    public IssuerResponse createIssuer(CreateIssuerRequest requestParameters) throws ApiException {
        ApiResponse<IssuerResponse> localVarResp = this.createIssuerWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<IssuerResponse> createIssuerWithHttpInfo(CreateIssuerRequest requestParameters) throws ApiException {
        Call localVarCall = this.createIssuerValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<IssuerResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIssuerAsync(CreateIssuerRequest requestParameters, ApiCallback<IssuerResponse> _callback) throws ApiException {
        Call localVarCall = this.createIssuerValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<IssuerResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateIssuerRequest getCreateIssuerRequest() {
        return new CreateIssuerRequest();
    }

    public Call deleteIssuerCall(DeleteIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/1099/issuers/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call deleteIssuerValidateBeforeCall(DeleteIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling deleteIssuer(Async)");
        }
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling deleteIssuer(Async)");
        }
        Call localVarCall = this.deleteIssuerCall(requestParameters, _callback);
        return localVarCall;
    }

    public void deleteIssuer(DeleteIssuerRequest requestParameters) throws ApiException {
        this.deleteIssuerWithHttpInfo(requestParameters);
    }

    public ApiResponse<Void> deleteIssuerWithHttpInfo(DeleteIssuerRequest requestParameters) throws ApiException {
        Call localVarCall = this.deleteIssuerValidateBeforeCall(requestParameters, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIssuerAsync(DeleteIssuerRequest requestParameters, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIssuerValidateBeforeCall(requestParameters, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteIssuerRequest getDeleteIssuerRequest() {
        return new DeleteIssuerRequest();
    }

    public Call getIssuerCall(GetIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/1099/issuers/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call getIssuerValidateBeforeCall(GetIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling getIssuer(Async)");
        }
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getIssuer(Async)");
        }
        Call localVarCall = this.getIssuerCall(requestParameters, _callback);
        return localVarCall;
    }

    public IssuerResponse getIssuer(GetIssuerRequest requestParameters) throws ApiException {
        ApiResponse<IssuerResponse> localVarResp = this.getIssuerWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<IssuerResponse> getIssuerWithHttpInfo(GetIssuerRequest requestParameters) throws ApiException {
        Call localVarCall = this.getIssuerValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<IssuerResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIssuerAsync(GetIssuerRequest requestParameters, ApiCallback<IssuerResponse> _callback) throws ApiException {
        Call localVarCall = this.getIssuerValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<IssuerResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetIssuerRequest getGetIssuerRequest() {
        return new GetIssuerRequest();
    }

    public Call getIssuersCall(GetIssuersRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/1099/issuers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.get$filter() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$filter", requestParameters.get$filter()));
        }
        if (requestParameters.get$top() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$top", requestParameters.get$top()));
        }
        if (requestParameters.get$skip() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$skip", requestParameters.get$skip()));
        }
        if (requestParameters.get$orderBy() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("$orderBy", requestParameters.get$orderBy()));
        }
        if (requestParameters.getCount() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", requestParameters.getCount()));
        }
        if (requestParameters.getCountOnly() != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("countOnly", requestParameters.getCountOnly()));
        }
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call getIssuersValidateBeforeCall(GetIssuersRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling getIssuers(Async)");
        }
        Call localVarCall = this.getIssuersCall(requestParameters, _callback);
        return localVarCall;
    }

    public PaginatedQueryResultModelIssuerResponse getIssuers(GetIssuersRequest requestParameters) throws ApiException {
        ApiResponse<PaginatedQueryResultModelIssuerResponse> localVarResp = this.getIssuersWithHttpInfo(requestParameters);
        return localVarResp.getData();
    }

    public ApiResponse<PaginatedQueryResultModelIssuerResponse> getIssuersWithHttpInfo(GetIssuersRequest requestParameters) throws ApiException {
        Call localVarCall = this.getIssuersValidateBeforeCall(requestParameters, null);
        Type localVarReturnType = new TypeToken<PaginatedQueryResultModelIssuerResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIssuersAsync(GetIssuersRequest requestParameters, ApiCallback<PaginatedQueryResultModelIssuerResponse> _callback) throws ApiException {
        Call localVarCall = this.getIssuersValidateBeforeCall(requestParameters, _callback);
        Type localVarReturnType = new TypeToken<PaginatedQueryResultModelIssuerResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetIssuersRequest getGetIssuersRequest() {
        return new GetIssuersRequest();
    }

    public Call updateIssuerCall(UpdateIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        String requiredScopes = "";
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IssuerCommand localVarPostBody = requestParameters.getIssuerCommand();
        String localVarPath = "/1099/issuers/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(requestParameters.id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestParameters.getAvalaraVersion() != null) {
            localVarHeaderParams.put("avalara-version", this.localVarApiClient.parameterToString(requestParameters.getAvalaraVersion()));
        }
        if (requestParameters.getXCorrelationId() != null) {
            localVarHeaderParams.put("X-Correlation-Id", this.localVarApiClient.parameterToString(requestParameters.getXCorrelationId()));
        }
        if (requestParameters.getXAvalaraClient() != null) {
            localVarHeaderParams.put("X-Avalara-Client", this.localVarApiClient.parameterToString(requestParameters.getXAvalaraClient()));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "text/json", "application/*+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth", "bearer"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback, requiredScopes, AvalaraMicroservice.A1099);
    }

    private Call updateIssuerValidateBeforeCall(UpdateIssuerRequest requestParameters, ApiCallback _callback) throws ApiException {
        if (requestParameters.getId() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.id' when calling updateIssuer(Async)");
        }
        if (requestParameters.getAvalaraVersion() == null) {
            throw new ApiException("Missing the required parameter 'requestParameters.avalaraVersion' when calling updateIssuer(Async)");
        }
        Call localVarCall = this.updateIssuerCall(requestParameters, _callback);
        return localVarCall;
    }

    public void updateIssuer(UpdateIssuerRequest requestParameters) throws ApiException {
        this.updateIssuerWithHttpInfo(requestParameters);
    }

    public ApiResponse<Void> updateIssuerWithHttpInfo(UpdateIssuerRequest requestParameters) throws ApiException {
        Call localVarCall = this.updateIssuerValidateBeforeCall(requestParameters, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateIssuerAsync(UpdateIssuerRequest requestParameters, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateIssuerValidateBeforeCall(requestParameters, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public UpdateIssuerRequest getUpdateIssuerRequest() {
        return new UpdateIssuerRequest();
    }

    private void SetConfiguration(ApiClient client) {
        if (client == null) {
            throw new MissingFormatArgumentException("client");
        }
        this.localVarApiClient.setSdkVersion("25.8.2");
    }

    public class UpdateIssuerRequest {
        private String id;
        private String avalaraVersion;
        private String xCorrelationId;
        private String xAvalaraClient;
        private IssuerCommand issuerCommand;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public IssuerCommand getIssuerCommand() {
            return this.issuerCommand;
        }

        public void setIssuerCommand(IssuerCommand issuerCommand) {
            this.issuerCommand = issuerCommand;
        }
    }

    public class GetIssuersRequest {
        private String avalaraVersion;
        private String $filter;
        private Integer $top;
        private Integer $skip;
        private String $orderBy;
        private Boolean count;
        private Boolean countOnly;
        private String xCorrelationId;
        private String xAvalaraClient;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String get$filter() {
            return this.$filter;
        }

        public void set$filter(String $filter) {
            this.$filter = $filter;
        }

        public Integer get$top() {
            return this.$top;
        }

        public void set$top(Integer $top) {
            this.$top = $top;
        }

        public Integer get$skip() {
            return this.$skip;
        }

        public void set$skip(Integer $skip) {
            this.$skip = $skip;
        }

        public String get$orderBy() {
            return this.$orderBy;
        }

        public void set$orderBy(String $orderBy) {
            this.$orderBy = $orderBy;
        }

        public Boolean getCount() {
            return this.count;
        }

        public void setCount(Boolean count) {
            this.count = count;
        }

        public Boolean getCountOnly() {
            return this.countOnly;
        }

        public void setCountOnly(Boolean countOnly) {
            this.countOnly = countOnly;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class GetIssuerRequest {
        private String id;
        private String avalaraVersion;
        private String xCorrelationId;
        private String xAvalaraClient;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class DeleteIssuerRequest {
        private String id;
        private String avalaraVersion;
        private String xCorrelationId;
        private String xAvalaraClient;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }
    }

    public class CreateIssuerRequest {
        private String avalaraVersion;
        private String xCorrelationId;
        private String xAvalaraClient;
        private IssuerCommand issuerCommand;

        public String getAvalaraVersion() {
            return this.avalaraVersion != null ? this.avalaraVersion : "2.0";
        }

        public void setAvalaraVersion(String avalaraVersion) {
            this.avalaraVersion = avalaraVersion;
        }

        public String getXCorrelationId() {
            return this.xCorrelationId;
        }

        public void setXCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
        }

        public String getXAvalaraClient() {
            return this.xAvalaraClient;
        }

        public void setXAvalaraClient(String xAvalaraClient) {
            this.xAvalaraClient = xAvalaraClient;
        }

        public IssuerCommand getIssuerCommand() {
            return this.issuerCommand;
        }

        public void setIssuerCommand(IssuerCommand issuerCommand) {
            this.issuerCommand = issuerCommand;
        }
    }
}

