/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK.auth;

import Avalara.SDK.AccessToken;
import Avalara.SDK.ApiException;
import Avalara.SDK.Pair;
import Avalara.SDK.auth.OAuth;
import Avalara.SDK.auth.ScopeWrapper;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class RetryingOAuth
extends OAuth
implements Interceptor {
    String tokenUrl;
    String clientId;
    String secret;
    AuthorizationGrant authorizationGrant;
    Map<String, List<String>> parameters;
    private Map<String, AccessToken> accessTokenCache = new HashMap<String, AccessToken>();

    public RetryingOAuth(String tokenUrl, String clientId, String clientSecret, AuthorizationGrant authorizationGrant, Map<String, List<String>> parameters) {
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.secret = clientSecret;
        this.authorizationGrant = authorizationGrant;
        this.parameters = parameters;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        String requestAccessToken;
        Request request = chain.request();
        ScopeWrapper wrapper = (ScopeWrapper)request.tag(ScopeWrapper.class);
        String scope = wrapper.getScope();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken(scope) == null) {
            this.updateAccessToken(scope, null);
        }
        if (StringUtils.isNotEmpty((CharSequence)(requestAccessToken = this.getAccessToken(scope)))) {
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.addHeader("Authorization", "Bearer " + requestAccessToken);
            requestBuilder.url(request.url().toString());
            Response response = chain.proceed(requestBuilder.build());
            if (response != null && (response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(scope, requestAccessToken)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    response.body().close();
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
    }

    @Override
    public String getAccessToken(String scope) {
        Instant nowPlus5Minutes;
        AccessToken accessToken = this.accessTokenCache.get(this.standardizeScopes(scope));
        if (!Objects.isNull(accessToken) && (nowPlus5Minutes = Instant.now().plusSeconds(300L)).isBefore(accessToken.getExpiryTime())) {
            return accessToken.getToken();
        }
        return null;
    }

    public void setAccessToken(String scope, String accessToken, long expiresInSeconds) {
        Instant expiryTime = Instant.now().plusSeconds(expiresInSeconds);
        AccessToken token = new AccessToken(accessToken, expiryTime);
        this.accessTokenCache.put(this.standardizeScopes(scope), token);
    }

    private String standardizeScopes(String scope) {
        Object[] strArray = scope.split(" ");
        Arrays.sort(strArray);
        return String.join((CharSequence)" ", (CharSequence[])strArray);
    }

    public synchronized boolean updateAccessToken(String scope, String requestAccessToken) {
        if (this.getAccessToken(scope) == null || this.getAccessToken(scope).equals(requestAccessToken)) {
            try {
                ClientID clientID = new ClientID(this.clientId);
                Secret clientSecret = new Secret(this.secret);
                ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
                URI tokenEndpoint = null;
                try {
                    tokenEndpoint = new URI(this.tokenUrl);
                }
                catch (URISyntaxException e) {
                    System.out.println("Error while creating the token URI");
                    throw e;
                }
                TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, this.authorizationGrant, new Scope(new String[]{scope}), null, this.parameters);
                TokenResponse tokenResponse = null;
                try {
                    tokenResponse = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
                }
                catch (IOException e) {
                    System.out.println("Error sending the token request");
                    throw e;
                }
                catch (ParseException e) {
                    System.out.println("Error parsing the response from Token request");
                    throw e;
                }
                if (!tokenResponse.indicatesSuccess()) {
                    ErrorObject errorResponse = tokenResponse.toErrorResponse().getErrorObject();
                    String errorMessage = "Token Fetch Failed Error Code: " + errorResponse.getCode() + " Error: " + errorResponse.getDescription();
                    System.out.println(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                AccessTokenResponse successResponse = tokenResponse.toSuccessResponse();
                com.nimbusds.oauth2.sdk.token.AccessToken accessToken = successResponse.getTokens().getAccessToken();
                RefreshToken refreshToken = successResponse.getTokens().getRefreshToken();
                if (accessToken != null && accessToken.getValue() != null) {
                    this.setAccessToken(scope, accessToken.getValue(), accessToken.getLifetime());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getAccessToken(scope) == null || !this.getAccessToken(scope).equals(requestAccessToken);
    }
}

