/*
 * Decompiled with CFR 0.152.
 */
package Avalara.SDK;

import Avalara.SDK.Configuration;
import Avalara.SDK.DeviceAccessTokenResponse;
import Avalara.SDK.DeviceAuthResponse;
import Avalara.SDK.OpenIdHelper;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationRequest;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationResponse;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.device.DeviceCode;
import com.nimbusds.oauth2.sdk.device.DeviceCodeGrant;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class ApiClientHelper {
    public static DeviceAuthResponse initiateDeviceAuthorizationOAuth(String scope, Configuration configuration) throws Exception {
        DeviceAuthResponse authResponse;
        OpenIdHelper.populateConfigWithOpenIdDetails(configuration);
        try {
            HTTPRequest deviceAuthorizationRequest;
            try {
                deviceAuthorizationRequest = new DeviceAuthorizationRequest.Builder(new ClientID(configuration.getClientId())).scope(StringUtils.isNotEmpty((CharSequence)scope) ? new Scope(new String[]{scope}) : null).endpointURI(new URI(configuration.getDeviceAuthorizationUrl())).build().toHTTPRequest();
            }
            catch (URISyntaxException e) {
                System.out.println("Unable to parse the device authorization uri");
                throw e;
            }
            HTTPResponse deviceAuthorizationHttpResponse = null;
            try {
                deviceAuthorizationHttpResponse = deviceAuthorizationRequest.send();
            }
            catch (IOException e) {
                System.out.println("Unable to get the response from device Authorization HTTP Request");
                throw e;
            }
            DeviceAuthorizationResponse deviceAuthorizationResponse = null;
            try {
                deviceAuthorizationResponse = DeviceAuthorizationResponse.parse((HTTPResponse)deviceAuthorizationHttpResponse);
            }
            catch (ParseException e) {
                System.out.println("Unable to parse the response from device Authorization Request");
                throw e;
            }
            if (!deviceAuthorizationResponse.indicatesSuccess()) {
                System.out.println("Error: " + deviceAuthorizationResponse.toErrorResponse().getErrorObject());
                throw new Exception(deviceAuthorizationResponse.toErrorResponse().getErrorObject().toString());
            }
            DeviceAuthorizationSuccessResponse successResponse = deviceAuthorizationResponse.toSuccessResponse();
            authResponse = new DeviceAuthResponse(successResponse.getDeviceCode().getValue(), successResponse.getUserCode().getValue(), successResponse.getVerificationURI().toString(), successResponse.getVerificationURIComplete().toString(), successResponse.getLifetime(), successResponse.getInterval());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return authResponse;
    }

    public static DeviceAccessTokenResponse getAccessTokenForDeviceFlow(String deviceAuthCode, Configuration configuration) {
        return ApiClientHelper.getAccessTokenForDeviceFlow(deviceAuthCode, null, configuration);
    }

    private static DeviceAccessTokenResponse getAccessTokenForDeviceFlow(String deviceAuthCode, String refreshToken, Configuration configuration) {
        DeviceAccessTokenResponse tokenResponse = null;
        try {
            DeviceCodeGrant codeGrant = null;
            if (StringUtils.isNotEmpty((CharSequence)deviceAuthCode)) {
                codeGrant = new DeviceCodeGrant(new DeviceCode(deviceAuthCode));
            } else if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
                codeGrant = new RefreshTokenGrant(new RefreshToken(refreshToken));
            }
            ClientID clientID = new ClientID(configuration.getClientId());
            URI tokenEndpoint = new URI(configuration.getTokenUrl());
            TokenRequest request = new TokenRequest(tokenEndpoint, clientID, (AuthorizationGrant)codeGrant);
            TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
            if (!response.indicatesSuccess()) {
                TokenErrorResponse errorResponse = response.toErrorResponse();
                tokenResponse = new DeviceAccessTokenResponse(errorResponse.getErrorObject().getHTTPStatusCode(), errorResponse.getErrorObject().getCode(), null, null, null, 0L, null, null);
                return tokenResponse;
            }
            AccessTokenResponse successResponse = response.toSuccessResponse();
            tokenResponse = new DeviceAccessTokenResponse(200, null, (String)successResponse.getCustomParameters().get("id_token"), successResponse.getTokens().getRefreshToken().getValue(), successResponse.getTokens().getAccessToken().getValue(), successResponse.getTokens().getAccessToken().getLifetime(), successResponse.getTokens().getAccessToken().getType().getValue(), successResponse.getTokens().getAccessToken().getScope().toString());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return tokenResponse;
    }

    public static DeviceAccessTokenResponse getAccessTokenUsingRefreshTokenForDeviceCodeFlow(String refreshToken, Configuration configuration) {
        return ApiClientHelper.getAccessTokenForDeviceFlow(null, refreshToken, configuration);
    }
}

