/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.ts.TransitionSystem;

class SimpleDFRecord<S, I, T> {
    public final S state;
    private final Iterator<? extends I> inputsIterator;
    private I input;
    private Iterator<T> transitionIterator;
    private T retractedTransition;

    public SimpleDFRecord(S state, Collection<? extends I> inputs) {
        this.state = state;
        this.inputsIterator = inputs.iterator();
    }

    private void findNext(TransitionSystem<S, I, T> ts) {
        if (this.transitionIterator != null && this.transitionIterator.hasNext()) {
            return;
        }
        while (this.inputsIterator.hasNext()) {
            this.input = this.inputsIterator.next();
            Collection transitions = ts.getTransitions(this.state, this.input);
            if (transitions == null || transitions.isEmpty()) continue;
            this.transitionIterator = transitions.iterator();
            break;
        }
    }

    public boolean start(TransitionSystem<S, I, T> ts) {
        if (this.transitionIterator != null) {
            return false;
        }
        this.findNext(ts);
        return true;
    }

    public boolean hasNextTransition() {
        if (this.retractedTransition != null) {
            return true;
        }
        if (this.transitionIterator == null) {
            return false;
        }
        return this.transitionIterator.hasNext();
    }

    public void advance(TransitionSystem<S, I, T> ts) {
        if (this.transitionIterator.hasNext()) {
            return;
        }
        this.findNext(ts);
    }

    public void advanceInput(TransitionSystem<S, I, T> ts) {
        this.transitionIterator = null;
        this.findNext(ts);
    }

    public I input() {
        return this.input;
    }

    public T transition() {
        return this.transitionIterator.next();
    }
}

