/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.acceptors;

import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.ts.acceptors.AcceptorTS;
import net.automatalib.ts.acceptors.DeterministicAcceptorTS;
import net.automatalib.util.ts.acceptors.AcceptanceCombiner;
import net.automatalib.util.ts.acceptors.DetAcceptorComposition;

public abstract class Acceptors {
    private Acceptors() {
    }

    public static <S1, S2, I, T1, T2, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> combine(TS1 ts1, TS2 ts2, AcceptanceCombiner combiner) {
        return new DetAcceptorComposition(ts1, ts2, combiner);
    }

    public static <S1, S2, I, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> and(TS1 ts1, TS2 ts2) {
        return Acceptors.combine(ts1, ts2, AcceptanceCombiner.AND);
    }

    public static <S1, S2, I, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> or(TS1 ts1, TS2 ts2) {
        return Acceptors.combine(ts1, ts2, AcceptanceCombiner.OR);
    }

    public static <S1, S2, I, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> xor(TS1 ts1, TS2 ts2) {
        return Acceptors.combine(ts1, ts2, AcceptanceCombiner.XOR);
    }

    public static <S1, S2, I, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> equiv(TS1 ts1, TS2 ts2) {
        return Acceptors.combine(ts1, ts2, AcceptanceCombiner.EQUIV);
    }

    public static <S1, S2, I, TS1 extends DeterministicAcceptorTS<S1, I>, TS2 extends DeterministicAcceptorTS<S2, I>> DetAcceptorComposition<S1, S2, I, TS1, TS2> impl(TS1 ts1, TS2 ts2) {
        return Acceptors.combine(ts1, ts2, AcceptanceCombiner.IMPL);
    }

    public static <S> Mapping<S, Boolean> acceptance(final AcceptorTS<S, ?> acceptor) {
        return new Mapping<S, Boolean>(){

            public Boolean get(S elem) {
                return acceptor.isAccepting(elem);
            }
        };
    }
}

