/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.acceptors;

public interface AcceptanceCombiner {
    public static final AcceptanceCombiner AND = new AcceptanceCombiner(){

        @Override
        public boolean combine(boolean a1, boolean a2) {
            return a1 && a2;
        }
    };
    public static final AcceptanceCombiner OR = new AcceptanceCombiner(){

        @Override
        public boolean combine(boolean a1, boolean a2) {
            return a1 || a2;
        }
    };
    public static final AcceptanceCombiner XOR = new AcceptanceCombiner(){

        @Override
        public boolean combine(boolean a1, boolean a2) {
            return a1 ^ a2;
        }
    };
    public static final AcceptanceCombiner EQUIV = new AcceptanceCombiner(){

        @Override
        public boolean combine(boolean a1, boolean a2) {
            return a1 == a2;
        }
    };
    public static final AcceptanceCombiner IMPL = new AcceptanceCombiner(){

        @Override
        public boolean combine(boolean a1, boolean a2) {
            return !a1 || a2;
        }
    };

    public boolean combine(boolean var1, boolean var2);
}

