/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.commons.util.collections.SimplifiedIterator;
import net.automatalib.commons.util.collections.TwoLevelIterator;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.ts.TS;

abstract class TSIterators {
    TSIterators() {
    }

    public static final class AllUndefinedTransitionsIterator<S, I>
    extends TwoLevelIterator<S, I, TS.TransRef<S, I>> {
        private final DeterministicTransitionSystem<S, I, ?> dts;
        private final Iterable<? extends I> inputs;

        public AllUndefinedTransitionsIterator(Iterator<? extends S> stateIt, DeterministicTransitionSystem<S, I, ?> dts, Iterable<? extends I> inputs) {
            super(stateIt);
            this.dts = dts;
            this.inputs = inputs;
        }

        protected Iterator<I> l2Iterator(S state) {
            return TS.undefinedTransitionsIterator(this.dts, state, this.inputs.iterator());
        }

        protected TS.TransRef<S, I> combine(S l1Object, I l2Object) {
            return new TS.TransRef<S, I>(l1Object, l2Object);
        }
    }

    public static final class UndefinedTransitionsIterator<S, I>
    extends SimplifiedIterator<I> {
        private final DeterministicTransitionSystem<S, I, ?> dts;
        private final Iterator<? extends I> inputsIt;
        private final S state;

        public UndefinedTransitionsIterator(DeterministicTransitionSystem<S, I, ?> dts, S state, Iterator<? extends I> inputsIt) {
            this.dts = dts;
            this.inputsIt = inputsIt;
            this.state = state;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected boolean calculateNext() {
            while (this.inputsIt.hasNext()) {
                I input = this.inputsIt.next();
                if (this.dts.getTransition(this.state, input) != null) continue;
                this.nextValue = input;
                return true;
            }
            return false;
        }
    }

    public static final class AllDefinedTransitionsIterator<S, I>
    extends TwoLevelIterator<S, I, TS.TransRef<S, I>> {
        private final DeterministicTransitionSystem<S, I, ?> dts;
        private final Iterable<? extends I> inputs;

        public AllDefinedTransitionsIterator(Iterator<? extends S> stateIt, DeterministicTransitionSystem<S, I, ?> dts, Iterable<? extends I> inputs) {
            super(stateIt);
            this.dts = dts;
            this.inputs = inputs;
        }

        protected Iterator<I> l2Iterator(S state) {
            return TS.definedTransitionsIterator(this.dts, state, this.inputs.iterator());
        }

        protected TS.TransRef<S, I> combine(S state, I input) {
            return new TS.TransRef<S, I>(state, input);
        }
    }

    public static final class DefinedTransitionsIterator<S, I>
    extends SimplifiedIterator<I> {
        private final DeterministicTransitionSystem<S, I, ?> dts;
        private final Iterator<? extends I> inputsIt;
        private final S state;

        public DefinedTransitionsIterator(DeterministicTransitionSystem<S, I, ?> dts, S state, Iterator<? extends I> inputsIt) {
            this.dts = dts;
            this.inputsIt = inputsIt;
            this.state = state;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected boolean calculateNext() {
            while (this.inputsIt.hasNext()) {
                I input = this.inputsIt.next();
                if (this.dts.getTransition(this.state, input) == null) continue;
                this.nextValue = input;
                return true;
            }
            return false;
        }
    }

    static final class AllTransitionsIterator<S, I, T>
    implements Iterator<T> {
        private final TransitionSystem<S, I, T> ts;
        private final S state;
        private final Iterator<I> inputIt;
        private Iterator<T> transIt;

        public AllTransitionsIterator(TransitionSystem<S, I, T> ts, S state, Collection<I> inputs) {
            this.ts = ts;
            this.state = state;
            this.inputIt = inputs.iterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.transIt.hasNext();
        }

        @Override
        public T next() {
            T t = this.transIt.next();
            if (!this.transIt.hasNext()) {
                this.findNext();
            }
            return t;
        }

        @Override
        public void remove() {
            this.transIt.remove();
        }

        private void findNext() {
            while (this.inputIt.hasNext()) {
                I input = this.inputIt.next();
                Collection trans = this.ts.getTransitions(this.state, input);
                if (trans == null || trans.isEmpty()) continue;
                this.transIt = trans.iterator();
                break;
            }
        }
    }
}

