/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.smartcollections.BasicLinkedListEntry;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.Edge;
import net.automatalib.util.minimizer.TransitionLabel;

final class State<S, L>
extends BasicLinkedListEntry<State<S, L>, State<S, L>> {
    private final int id;
    private final S originalState;
    private final List<Edge<S, L>> incoming = new ArrayList<Edge<S, L>>();
    private final List<Edge<S, L>> outgoing = new ArrayList<Edge<S, L>>();
    private Block<S, L> block;
    private ElementReference blockReference;
    private boolean splitPoint;
    private List<TransitionLabel<S, L>> signature = new ArrayList<TransitionLabel<S, L>>();

    public State(int id, S originalState) {
        this.id = id;
        this.originalState = originalState;
    }

    public int getId() {
        return this.id;
    }

    public S getOriginalState() {
        return this.originalState;
    }

    public void setBlock(Block<S, L> block) {
        this.block = block;
    }

    public Block<S, L> getBlock() {
        return this.block;
    }

    public List<Edge<S, L>> getIncoming() {
        return this.incoming;
    }

    public List<Edge<S, L>> getOutgoing() {
        return this.outgoing;
    }

    public void addIncomingEdge(Edge<S, L> edge) {
        this.incoming.add(edge);
    }

    public void addOutgoingEdge(Edge<S, L> edge) {
        this.outgoing.add(edge);
    }

    public void setSplitPoint(boolean splitPoint) {
        this.splitPoint = splitPoint;
    }

    public boolean isSplitPoint() {
        return this.splitPoint;
    }

    public void reset() {
        this.splitPoint = false;
        if (this.signature == null) {
            this.signature = new ArrayList<TransitionLabel<S, L>>();
        } else {
            this.signature.clear();
        }
    }

    public boolean addToSignature(TransitionLabel<S, L> letter) {
        boolean first = this.signature.isEmpty();
        this.signature.add(letter);
        return first;
    }

    public TransitionLabel<S, L> getSignatureLetter(int index) {
        if (index < this.signature.size()) {
            return this.signature.get(index);
        }
        return null;
    }

    public void setBlockReference(ElementReference ref) {
        this.blockReference = ref;
    }

    public ElementReference getBlockReference() {
        return this.blockReference;
    }

    public List<TransitionLabel<S, L>> getSignature() {
        return this.signature;
    }

    public boolean isSingletonBlock() {
        return this.block.size() == 1;
    }

    public String toString() {
        return this.originalState.toString();
    }

    public State<S, L> getElement() {
        return this;
    }
}

