/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.graphs.UniversalIndefiniteGraph;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.InitialPartitioning;

class HashMapInitialPartitioning<S, L>
implements InitialPartitioning<S, L> {
    private final Map<Object, Block<S, L>> initialBlockMap = new HashMap<Object, Block<S, L>>();
    private final UniversalIndefiniteGraph<S, ?, ?, L> graph;
    private int numExistingBlocks;

    public HashMapInitialPartitioning(UniversalIndefiniteGraph<S, ?, ?, L> graph) {
        this.graph = graph;
    }

    @Override
    public Block<S, L> getBlock(S origState) {
        Object clazz = this.graph.getNodeProperty(origState);
        Block<S, L> block = this.initialBlockMap.get(clazz);
        if (block == null) {
            block = new Block(this.numExistingBlocks++);
            this.initialBlockMap.put(clazz, block);
        }
        return block;
    }

    @Override
    public Collection<Block<S, L>> getInitialBlocks() {
        return this.initialBlockMap.values();
    }
}

