/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.automatalib.graphs.IndefiniteGraph;

class SimpleDFRecord<N, E> {
    public final N node;
    private Iterator<E> edgeIterator;
    private E retractedEdge = null;

    public SimpleDFRecord(N node) {
        this.node = node;
    }

    public final boolean wasStarted() {
        return this.edgeIterator != null;
    }

    public final boolean start(IndefiniteGraph<N, E> graph) {
        if (this.edgeIterator != null) {
            return false;
        }
        Collection outEdges = graph.getOutgoingEdges(this.node);
        this.edgeIterator = outEdges == null ? Collections.emptySet().iterator() : outEdges.iterator();
        return true;
    }

    public final boolean hasNextEdge() {
        return this.retractedEdge != null || this.edgeIterator != null && this.edgeIterator.hasNext();
    }

    public final E nextEdge() {
        if (this.retractedEdge != null) {
            E tmp = this.retractedEdge;
            this.retractedEdge = null;
            return tmp;
        }
        return this.edgeIterator.next();
    }

    public final void retract(E edge) {
        assert (this.retractedEdge == null);
        this.retractedEdge = edge;
    }
}

