/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.traversal.VisitedState;

final class BreadthFirstIterator<N, E>
implements Iterator<N> {
    private final Queue<N> bfsQueue = new ArrayDeque<N>();
    private final MutableMapping<N, VisitedState> visited;
    private final IndefiniteGraph<N, E> graph;

    public BreadthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        this.graph = graph;
        this.visited = graph.createStaticNodeMapping();
        this.bfsQueue.addAll(start);
    }

    @Override
    public boolean hasNext() {
        return !this.bfsQueue.isEmpty();
    }

    @Override
    public N next() {
        N result = this.bfsQueue.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        for (Object edge : this.graph.getOutgoingEdges(result)) {
            Object tgt = this.graph.getTarget(edge);
            if (this.visited.put(tgt, (Object)VisitedState.VISITED) == VisitedState.VISITED) continue;
            this.bfsQueue.add(tgt);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

