/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.dot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.dot.DOTPlottableAutomaton;
import net.automatalib.automata.dot.DefaultDOTHelperAutomaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.UndirectedGraph;
import net.automatalib.graphs.dot.AggregateDOTHelper;
import net.automatalib.graphs.dot.DOTPlottableGraph;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.util.automata.Automata;

public abstract class GraphDOT {
    @SafeVarargs
    public static <N, E> void write(DOTPlottableGraph<N, E> graph, Appendable a, GraphDOTHelper<N, ? super E> ... additionalHelpers) throws IOException {
        GraphDOTHelper helper = graph.getGraphDOTHelper();
        GraphDOT.write(graph, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, GraphDOTHelper<S, ? super TransitionEdge<I, T>> helper, Collection<? extends I> inputAlphabet, Appendable a, GraphDOTHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        Graph<S, TransitionEdge<? extends I, T>> ag = Automata.asGraph(automaton, inputAlphabet);
        GraphDOT.write(ag, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, GraphDOTHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        DefaultDOTHelperAutomaton helper;
        if (automaton instanceof DOTPlottableAutomaton) {
            DOTPlottableAutomaton dp = (DOTPlottableAutomaton)automaton;
            helper = dp.getDOTHelper();
        } else {
            helper = new DefaultDOTHelperAutomaton(automaton);
        }
        GraphDOT.write(automaton, helper, inputAlphabet, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(DOTPlottableAutomaton<S, I, T> automaton, Appendable a, GraphDOTHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        GraphDOT.write(automaton, automaton.getDOTHelper(), automaton.getInputAlphabet(), a, additionalHelpers);
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, Appendable a, GraphDOTHelper<N, ? super E> ... additionalHelpers) throws IOException {
        DefaultDOTHelper helper = null;
        if (graph instanceof DOTPlottableGraph) {
            DOTPlottableGraph plottable = (DOTPlottableGraph)graph;
            helper = plottable.getGraphDOTHelper();
        } else {
            helper = DefaultDOTHelper.getInstance();
        }
        GraphDOT.write(graph, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, GraphDOTHelper<N, ? super E> helper, Appendable a, GraphDOTHelper<N, ? super E> ... additionalHelpers) throws IOException {
        ArrayList<GraphDOTHelper<N, GraphDOTHelper<N, ? super E>>> helpers = new ArrayList<GraphDOTHelper<N, GraphDOTHelper<N, ? super E>>>(additionalHelpers.length + 1);
        helpers.add(helper);
        helpers.addAll(Arrays.asList(additionalHelpers));
        GraphDOT.write(graph, a, helpers);
    }

    public static <N, E> void write(Graph<N, E> graph, Appendable a, List<GraphDOTHelper<N, ? super E>> helpers) throws IOException {
        AggregateDOTHelper aggHelper = new AggregateDOTHelper(helpers);
        GraphDOT.write(graph, aggHelper, a);
    }

    public static <N, E> void write(Graph<N, E> graph, GraphDOTHelper<N, ? super E> dotHelper, Appendable a) throws IOException {
        if (dotHelper == null) {
            dotHelper = new DefaultDOTHelper();
        }
        boolean directed = true;
        if (graph instanceof UndirectedGraph) {
            directed = false;
        }
        if (directed) {
            a.append("di");
        }
        a.append("graph g {\n");
        dotHelper.writePreamble(a);
        a.append('\n');
        HashMap<String, String> props = new HashMap<String, String>();
        MutableMapping nodeNames = graph.createStaticNodeMapping();
        int i = 0;
        for (Object node : graph) {
            props.clear();
            if (!dotHelper.getNodeProperties(node, props)) continue;
            String id = "s" + i++;
            a.append('\t').append(id);
            GraphDOT.appendParams(props, a);
            a.append(";\n");
            nodeNames.put(node, (Object)id);
        }
        for (Object node : graph) {
            Collection outEdges;
            String srcId = (String)nodeNames.get(node);
            if (srcId == null || (outEdges = graph.getOutgoingEdges(node)) == null || outEdges.isEmpty()) continue;
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                String tgtId = (String)nodeNames.get(tgt);
                if (tgtId == null || !directed && tgtId.compareTo(srcId) < 0) continue;
                props.clear();
                if (!dotHelper.getEdgeProperties(node, e, tgt, props)) continue;
                a.append('\t').append(srcId).append(' ');
                if (directed) {
                    a.append("-> ");
                } else {
                    a.append("-- ");
                }
                a.append(tgtId);
                GraphDOT.appendParams(props, a);
                a.append(";\n");
            }
        }
        a.append('\n');
        dotHelper.writePostamble((Mapping)nodeNames, a);
        a.append("}\n");
    }

    public static <N, E> void writeToFile(Graph<N, E> graph, GraphDOTHelper<N, E> dotHelper, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            GraphDOT.write(graph, dotHelper, writer);
        }
    }

    private static void appendParams(Map<String, String> params, Appendable a) throws IOException {
        if (params == null || params.isEmpty()) {
            return;
        }
        a.append(" [");
        boolean first = true;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                a.append(' ');
            }
            String key = e.getKey();
            String value = e.getValue();
            a.append(e.getKey()).append("=");
            if (key.equals("label") && value.startsWith("<HTML>")) {
                a.append('<').append(value.substring(6)).append('>');
                continue;
            }
            StringUtil.enquote((String)e.getValue(), (Appendable)a);
        }
        a.append(']');
    }
}

