/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.copy;

import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.MutableGraph;

abstract class AbstractGraphCopy<N1, E1, N2, E2, NP2, EP2, G1 extends IndefiniteGraph<N1, E1>> {
    protected final MutableMapping<N1, N2> nodeMapping;
    protected final G1 inGraph;
    protected final MutableGraph<N2, E2, NP2, EP2> outGraph;
    protected final Mapping<? super N1, ? extends NP2> npMapping;
    protected final Mapping<? super E1, ? extends EP2> epMapping;

    public AbstractGraphCopy(G1 inGraph, MutableGraph<N2, E2, NP2, EP2> outGraph, Mapping<? super N1, ? extends NP2> npMapping, Mapping<? super E1, ? extends EP2> epMapping) {
        this.inGraph = inGraph;
        this.outGraph = outGraph;
        this.nodeMapping = inGraph.createStaticNodeMapping();
        this.npMapping = npMapping;
        this.epMapping = epMapping;
    }

    protected N2 copyNode(N1 node) {
        Object prop = this.npMapping.get(node);
        Object n2 = this.outGraph.addNode(prop);
        this.nodeMapping.put(node, n2);
        return (N2)n2;
    }

    protected E2 copyEdge(N2 src2, E1 edge) {
        return this.copyEdge(src2, edge, this.inGraph.getTarget(edge));
    }

    protected E2 copyEdge(N2 src2, E1 edge, N1 tgt1) {
        Object prop = this.epMapping.get(edge);
        Object tgt2 = this.nodeMapping.get(tgt1);
        return (E2)this.outGraph.connect(src2, tgt2, prop);
    }

    protected N2 copyEdgeChecked(N2 source, E1 edge, N1 tgt1) {
        Object prop = this.epMapping.get(edge);
        Object tgt2 = this.nodeMapping.get(tgt1);
        N2 freshTgt = null;
        if (tgt2 == null) {
            tgt2 = this.copyNode(tgt1);
            freshTgt = (N2)tgt2;
        }
        this.outGraph.connect(source, tgt2, prop);
        return freshTgt;
    }

    public Mapping<N1, N2> getNodeMapping() {
        return this.nodeMapping;
    }

    public abstract void doCopy();
}

