/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.random.RandomUtil;

public class AbstractRandomAutomatonGenerator<S, I, T, SP, TP, A extends MutableAutomaton<S, I, T, SP, TP>> {
    protected final RandomUtil random;
    protected final List<? extends I> inputs;
    protected final List<? extends SP> spList;
    protected final List<? extends TP> tpList;
    protected final ArrayList<S> states;
    protected final A automaton;

    public AbstractRandomAutomatonGenerator(Random random, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A automaton) {
        this.random = new RandomUtil(random);
        this.spList = stateProps == null ? Collections.singletonList(null) : CollectionsUtil.randomAccessList(stateProps);
        this.tpList = transProps == null ? Collections.singletonList(null) : CollectionsUtil.randomAccessList(transProps);
        this.inputs = CollectionsUtil.randomAccessList(inputs);
        this.states = new ArrayList();
        this.automaton = automaton;
    }

    public A getAutomaton() {
        return this.automaton;
    }

    protected SP randomStateProperty() {
        return (SP)this.random.choose(this.spList);
    }

    protected TP randomTransProperty() {
        return (TP)this.random.choose(this.tpList);
    }

    protected S randomState() {
        return (S)this.random.choose(this.states);
    }

    protected S randomDistinctState(int stateIdx) {
        if (this.states.size() == 1) {
            return null;
        }
        int idx = this.random.getRandom().nextInt(this.states.size() - 1);
        if (idx >= stateIdx) {
            ++idx;
        }
        return this.states.get(idx);
    }

    protected I randomInput() {
        return (I)this.random.choose(this.inputs);
    }

    public void addStates(int numStates) {
        this.states.ensureCapacity(this.states.size() + numStates);
        for (int i = 0; i < numStates; ++i) {
            Object state = this.automaton.addState(this.randomStateProperty());
            this.states.add(state);
        }
    }

    public void chooseInitial() {
        Object init = this.random.choose(this.states);
        this.automaton.setInitial(init, true);
    }

    public void chooseIntials(int num) {
        List inits = this.random.sampleUnique(this.states, num);
        for (Object init : inits) {
            this.automaton.setInitial(init, true);
        }
    }
}

