/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.asgraph;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.util.automata.asgraph.AGHelper;

public class AutomatonAsGraph<S, I, T, A extends Automaton<S, I, T>>
implements Graph<S, TransitionEdge<I, T>> {
    protected final A automaton;
    protected final Collection<? extends I> inputAlphabet;

    public AutomatonAsGraph(A automaton, Collection<? extends I> inputAlphabet) {
        this.automaton = automaton;
        this.inputAlphabet = inputAlphabet;
    }

    public Iterator<S> iterator() {
        return this.automaton.iterator();
    }

    public Collection<S> getNodes() {
        return this.automaton.getStates();
    }

    public Collection<TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AGHelper.outgoingEdges(this.automaton, node, this.inputAlphabet);
    }

    public S getTarget(TransitionEdge<I, T> edge) {
        return (S)this.automaton.getSuccessor(edge.getTransition());
    }

    public int size() {
        return this.automaton.size();
    }

    public <V> MutableMapping<S, V> createStaticNodeMapping() {
        return this.automaton.createStaticStateMapping();
    }

    public <V> MutableMapping<S, V> createDynamicNodeMapping() {
        return this.automaton.createDynamicStateMapping();
    }

    public NodeIDs<S> nodeIDs() {
        final StateIDs stateIds = this.automaton.stateIDs();
        return new NodeIDs<S>(){

            public int getNodeId(S node) {
                return stateIds.getStateId(node);
            }

            public S getNode(int id) {
                return stateIds.getState(id);
            }
        };
    }
}

